/*
 * Decompiled with CFR 0.152.
 */
package com.trollchannel.main;

import com.trollchannel.main.DriveDownload;
import com.trollchannel.main.StacktraceRunnable;
import com.trollchannel.main.UncaughtExceptionHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class Main {
    private static final String TEXT_VERSION = "Version: 1.52";
    public static String FILE_LOCATION = "D:/testy";
    public static JFrame mainFrame;
    public static JFrame exceptionFrame;
    public static JTextPane versionText;
    public static JTextPane exceptionText;
    public static JButton updateButton;
    public static JButton testButton;
    public static JButton getServerAddressButton;
    public static JButton fileChooserButton;
    public static JProgressBar updateProgressBar;
    public static JTextField modTextField;
    public static JTextField modDownloadField;
    public static JCheckBox combineCheckbox;
    public static JPopupMenu exceptionPopup;

    public static void main(String[] args) {
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler(defaultHandler, new StacktraceRunnable(){

            @Override
            public void run(String stacktrace) {
                Main.printExceptionToExceptionFrame(stacktrace);
            }
        }));
        DriveDownload.CheckForUpdate();
        mainFrame = new JFrame();
        mainFrame.setSize(800, 600);
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setTitle("Minecraft Mod Sync");
        mainFrame.setLayout(null);
        exceptionFrame = new JFrame();
        exceptionFrame.setSize(800, 600);
        exceptionFrame.setDefaultCloseOperation(2);
        exceptionFrame.setTitle("Minecraft Mod Sync (Error with Exception)");
        exceptionFrame.setLayout(null);
        exceptionFrame.setAlwaysOnTop(true);
        exceptionFrame.setVisible(false);
        updateProgressBar = new JProgressBar();
        updateProgressBar.setBounds(0, 0, 500, 30);
        updateProgressBar.setMinimum(0);
        updateProgressBar.setMaximum(100);
        updateProgressBar.setValue(0);
        updateProgressBar.setIndeterminate(true);
        mainFrame.add(updateProgressBar);
        versionText = new JTextPane();
        versionText.setText(TEXT_VERSION);
        versionText.setEditable(false);
        versionText.setBounds(500, 0, 150, 50);
        mainFrame.add(versionText);
        exceptionText = new JTextPane();
        exceptionText.setText("Error");
        exceptionText.setEditable(false);
        exceptionText.setBounds(0, 0, 800, 600);
        exceptionFrame.add(exceptionText);
        getServerAddressButton = new JButton("Get Ngrok Server Address");
        getServerAddressButton.setBounds(0, 30, 400, 50);
        getServerAddressButton.addActionListener(e -> {
            String myString = new String(DriveDownload.downloadNgrokAddress().toByteArray());
            StringSelection stringSelection = new StringSelection(myString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
            getServerAddressButton.setText("Get Ngrok Server Address\n(Text Copied: " + myString + ")");
            Main.printExceptionToExceptionFrame(myString);
        });
        mainFrame.add(getServerAddressButton);
        updateButton = new JButton("Sync Mod");
        updateButton.setBounds(0, 80, 200, 50);
        updateButton.addActionListener(e -> {
            if (Main.downloadAndInject(true)) {
                Main.terminateAndSave();
            }
        });
        mainFrame.add(updateButton);
        testButton = new JButton("Sync Mod Direct");
        testButton.setBounds(0, 130, 200, 50);
        testButton.addActionListener(e -> {
            if (Main.downloadAndInject(true)) {
                Main.terminateAndSave();
            }
        });
        mainFrame.add(testButton);
        combineCheckbox = new JCheckBox("Combine Mod");
        combineCheckbox.setBounds(200, 80, 200, 100);
        mainFrame.add(combineCheckbox);
        modTextField = new JTextField(String.valueOf(System.getenv("APPDATA")) + "/.minecraft/mods/");
        modTextField.setBounds(0, 180, 200, 50);
        mainFrame.add(modTextField);
        fileChooserButton = new JButton("...");
        fileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File("."));
                chooser.setDialogTitle("Browse the folder to process");
                chooser.setFileSelectionMode(1);
                chooser.setAcceptAllFileFilterUsed(false);
                if (chooser.showOpenDialog(null) == 0) {
                    System.out.println("getCurrentDirectory(): " + chooser.getCurrentDirectory());
                    System.out.println("getSelectedFile() : " + chooser.getSelectedFile());
                    modTextField.setText(String.valueOf(chooser.getSelectedFile().toString()) + "/");
                    Main.save();
                } else {
                    System.out.println("No Selection ");
                }
            }
        });
        fileChooserButton.setBounds(200, 180, 50, 50);
        mainFrame.add(fileChooserButton);
        modDownloadField = new JTextField("");
        modDownloadField.setBounds(0, 230, 350, 50);
        mainFrame.add(modDownloadField);
        mainFrame.setVisible(true);
        try {
            File file = new File(String.valueOf(System.getenv("APPDATA")) + "/minecraft_sync");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            modTextField.setText(reader.readLine());
            reader.close();
        }
        catch (Exception e2) {
            Main.printExceptionToExceptionFrame(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean downloadAndInject(boolean isDirect) {
        FILE_LOCATION = modTextField.getText();
        try {
            ZipEntry entry;
            if (!combineCheckbox.isSelected()) {
                File index = new File(FILE_LOCATION);
                if (index.exists()) {
                    String[] entries = index.list();
                    if (entries != null) {
                        String[] stringArray = entries;
                        int n = entries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            File currentFile = new File(index.getPath(), s);
                            currentFile.delete();
                            ++n2;
                        }
                    }
                    index.delete();
                }
                System.out.println("Deleting Old Mod Folder");
            }
            ByteArrayInputStream in = new ByteArrayInputStream(DriveDownload.download(isDirect).toByteArray());
            File workingFile = new File(FILE_LOCATION);
            if (!workingFile.exists()) {
                workingFile.mkdirs();
            }
            ZipInputStream zipIn = new ZipInputStream(in);
            while ((entry = zipIn.getNextEntry()) != null) {
                String fileName = entry.getName();
                System.out.println("Extracting: " + fileName);
                String filePath = String.valueOf(FILE_LOCATION) + "/" + fileName.split("/")[1];
                File file = new File(filePath);
                if (!file.exists()) {
                    if (file.isDirectory() || !fileName.contains(".")) {
                        file.mkdirs();
                        continue;
                    }
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                try {
                    int bytesRead;
                    FileOutputStream fos = new FileOutputStream(filePath);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = zipIn.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                }
                catch (Exception e) {
                    Main.printExceptionToExceptionFrame(e);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            Main.printExceptionToExceptionFrame(e);
            return false;
        }
    }

    public static void save() {
        try {
            File file = new File(String.valueOf(System.getenv("APPDATA")) + "/minecraft_sync");
            file.createNewFile();
            BufferedWriter writer = new BufferedWriter(new PrintWriter(file));
            writer.write(modTextField.getText());
            writer.close();
        }
        catch (Exception e) {
            Main.printExceptionToExceptionFrame(e);
        }
    }

    public static void terminateAndSave() {
        Main.save();
        System.exit(0);
    }

    public static void printExceptionToExceptionFrame(Exception e) {
        exceptionFrame.setAlwaysOnTop(true);
        exceptionFrame.setVisible(true);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        exceptionText.setText(stackTrace);
    }

    public static void printExceptionToExceptionFrame(String stackTrace) {
        exceptionFrame.setAlwaysOnTop(true);
        exceptionFrame.setVisible(true);
        exceptionText.setText(stackTrace);
    }
}

