package com.example.phanmemtoanhoc;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import java.io.PrintWriter;
import java.io.StringWriter;

public class WelcomeActivity extends AppCompatActivity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Thread.UncaughtExceptionHandler thread = new Thread.UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {

                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                String stackTrace = stringWriter.toString();

                Intent intent = new Intent(WelcomeActivity.this, CrashActivity.class);
                intent.putExtra("Stacktrace", stackTrace);
                try {
                    PendingIntent.getActivity(WelcomeActivity.this, 0, intent, PendingIntent.FLAG_IMMUTABLE).send();
                } catch (PendingIntent.CanceledException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(thread);


        // Đặt content_main làm view chính, lưu ý đặt một lần thôi nha
        setContentView(R.layout.content_main);
        
        // Ở đây em dùng hình (ImageView) nên sẽ lấy ImageView bằng hàm findViewById
        ImageView btn_calcHeight = findViewById(R.id.tree_icon);
        ImageView btn_calcWidth = findViewById(R.id.boat_icon);


        // Tiếp theo ta đặt code chạy khi bức hình được bấm vào
        btn_calcHeight.setOnClickListener(v -> {
            // Ta dùng intent, là một thứ để thao tác với các Activity khác, đây là ví dụ cho việc dùng intent để 
            // chuyển qua TreeActivity nên anh để TreeActivity.class, về phần trước đó, (thís) nó là Context của app
            // Context là thứ mà android dựa vào đó mà thực thi các lệnh mà app em yêu cầu, nên cần phải có nó ta mới
            // có thể chuyển app
            Intent intent = new Intent(this, MidActivity.class);
            intent.putExtra("Mode", MidActivity.MODE.HEIGHT.ordinal());
            chuyenActivity(this, intent);
            // Để chuyển qua bất kì Activity nào chúng ta cũng cần FLAG này.
            // hàm này để yêu cầu đt mở Activity chứa trong cái Intent mà ta vừa tạo

        });



        
        // Em thấy code này giống y chang cái ở trên, chỉ khác mỗi cái calcHeight và calcWidth
        // và thay vì TreeActivity thì nó là BoatActivity đúng ko?
        // Vậy là code đã y chang nhau, ta có thể gộp lại!
        // Bằng cách nào?
        btn_calcWidth.setOnClickListener(v -> {
            Intent intent = new Intent(this, MidActivity.class);
            intent.putExtra("Mode", MidActivity.MODE.WIDTH.ordinal());
            chuyenActivity(this, intent);

        });




    }


    // Bằng cách tạo một hàm mới!
    // Ta có thể cho các biến vào như sau
    // Intent cần 2 biến để tạo ra instance mới, nó là Context và Class<?>
    // Context thì ở trên anh nói rồi, nên ko nhắc lại
    // Class<?> với dấu ? tức là Class (Lớp) bất kì mà ta muốn, ở đây để khởi động một Activity khác
    // thì ta cần Class nào có extends, tức kế thừa, AppCompatActivity, hoặc Activity!
    // Tại sao lại là public STATIC void? STATIC để làm gì?
    // static để chỉ rằng hàm này là tĩnh trong lớp này và có thể dùng trong các lớp khác,
    // nếu muốn xem cách thức sử dụng ở các lớp khác, em có thể qua phần trả lời của TreeActivity và BoatActivity
    // Chúng ta chỉ cần đơn giản cho 2 cái đó vô ở phần hàm
    public static void chuyenActivity(Context context, Class<?> activity)
    {
        Intent intent = new Intent(context, activity);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }
    public static void chuyenActivity(Context context, Intent intent)
    {
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    // Sau khi ta có hàm này rồi, chúng ta biết nên làm gì rồi chứ?


    /*
    ở hàm onCreate trên, anh có nói về phần code dưới nhìn khá giống code trên. đúng chứ?
    em có thể thay đổi hoàn toàn cả 2 cái lần lượt là:

    Thử đoán đi!

    Sau khi thay đổi xong
    Lướt tới cuối đoạn code này để xem liệu em đã code đúng chưa nhé








































    Trước khi chỉnh, đoạn code sẽ nhìn như thế này:


        btn_calcHeight.setOnClickListener(v -> {
            Intent intent = new Intent(this, TreeActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
        });
        btn_calcWidth.setOnClickListener(v -> {
            Intent intent = new Intent(this, BoatActivity.class);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
        });




    Sau khi chỉnh lại, đoạn code sẽ nhìn như thế này:



        btn_calcHeight.setOnClickListener(v -> chuyenActivity(this, TreeActivity.class));
        btn_calcWidth.setOnClickListener(v -> chuyenActivity(this, BoatActivity.class));



     */
}
