package com.example.phanmemtoanhoc;

import static java.lang.Math.PI;
import static java.lang.Math.cos;
import static java.lang.Math.sin;
import static java.lang.Math.sqrt;
import static java.lang.Math.tan;

import android.os.Bundle;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;

import com.example.phanmemtoanhoc.R;

import java.lang.Math;

public class MainActivity extends AppCompatActivity {

    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        //setContentView(R.layout.content_main);

    // Initialize UI components for luongGiac
        EditText etAngle1 = findViewById(R.id.et_angle1);
        EditText etSide1 = findViewById(R.id.et_side1);
        Button btnCalculate1 = findViewById(R.id.btn_calculate_method1);
        TextView tvResult1 = findViewById(R.id.tv_result_method1);

        btnCalculate1.setOnClickListener(v -> {

            try {
                double angle1 = Double.parseDouble(etAngle1.getText().toString());
                double side1 = Double.parseDouble(etSide1.getText().toString());


                double result = luongGiac(angle1, side1);
                tvResult1.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult1.setText("Vui lòng nhập giá trị hợp lệ.");
            }

        });

        // Initialize UI components for doubleLuongGiac
        EditText etangle21 = findViewById(R.id.et_angle2_1);
        EditText etangle22 = findViewById(R.id.et_angle2_2);
        EditText etSide2 = findViewById(R.id.et_side2);
        Button btnCalculate2 = findViewById(R.id.btn_calculate_method2);
        TextView tvResult2 = findViewById(R.id.tv_result_method2);

        btnCalculate2.setOnClickListener(v -> {

            try {
                double angle21 = Double.parseDouble(etangle21.getText().toString());
                double angle22 = Double.parseDouble(etangle22.getText().toString());
                double side2 = Double.parseDouble(etSide2.getText().toString());
                double result = doubleLuongGiac(angle21, angle22, side2);
                tvResult2.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult2.setText("Vui lòng nhập giá trị hợp lệ.");
            }

        });

        // Initialize UI components for haigocvahaicanh
        EditText etangle31 = findViewById(R.id.et_angle3_1);
        EditText etangle32 = findViewById(R.id.et_angle1_2);
        EditText etside31 = findViewById(R.id.et_side1_1);
        EditText etside32 = findViewById(R.id.et_side1_2);
        Button btnCalculate3 = findViewById(R.id.btn_calculate_method3);
        TextView tvResult3 = findViewById(R.id.tv_result_method3);

        btnCalculate3.setOnClickListener(v -> {

            try {
                double angle31 = Double.parseDouble(etangle31.getText().toString());
                double angle32 = Double.parseDouble(etangle32.getText().toString());
                double side31 = Double.parseDouble(etside31.getText().toString());
                double side32 = Double.parseDouble(etside32.getText().toString());
                double result = haigocvahaicanh(angle31, angle32, side31, side32);
                tvResult3.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult3.setText("Vui lòng nhập giá trị hợp lệ.");
            }

        });

        // Initialize UI components for dodaibongocvamotcanh
        EditText etangle41 = findViewById(R.id.et_angle4_1);
        EditText etangle42 = findViewById(R.id.et_angle4_2);
        EditText etangle43 = findViewById(R.id.et_angle4_3);
        EditText etangle44 = findViewById(R.id.et_angle4_4);
        EditText etSide4 = findViewById(R.id.et_side3);
        Button btnCalculate4 = findViewById(R.id.btn_calculate_method4);
        TextView tvResult4 = findViewById(R.id.tv_result_method4);

        btnCalculate4.setOnClickListener(v -> {

            try {
                double angle41 = Double.parseDouble(etangle41.getText().toString());
                double angle42 = Double.parseDouble(etangle42.getText().toString());
                double angle43 = Double.parseDouble(etangle43.getText().toString());
                double angle44 = Double.parseDouble(etangle44.getText().toString());
                double side4 = Double.parseDouble(etSide4.getText().toString());
                double result = dodaibongocvamotcanh(angle41, angle42, angle43, angle44, side4);
                tvResult4.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult4.setText("Vui lòng nhập giá trị hợp lệ.");
            }
        });

        // Initialize UI components for dodaibongocvahaicanh
        EditText etangle51 = findViewById(R.id.et_angle4_1);
        EditText etangle52 = findViewById(R.id.et_angle4_2);
        EditText etangle53 = findViewById(R.id.et_angle4_3);
        EditText etangle54 = findViewById(R.id.et_angle4_4);
        EditText etside51 = findViewById(R.id.et_side4_1);
        EditText etside52 = findViewById(R.id.et_side4_2);
        Button btnCalculate5 = findViewById(R.id.btn_calculate_method5);
        TextView tvResult5 = findViewById(R.id.tv_result_method5);

        btnCalculate5.setOnClickListener(v ->
        {
            try {
                double angle51 = Double.parseDouble(etangle51.getText().toString());
                double angle52 = Double.parseDouble(etangle52.getText().toString());
                double angle53 = Double.parseDouble(etangle53.getText().toString());
                double angle54 = Double.parseDouble(etangle54.getText().toString());
                double side51 = Double.parseDouble(etside51.getText().toString());
                double side52 = Double.parseDouble(etside52.getText().toString());
                double result = dodaibongocvahaicanh(angle51, angle52, angle53, angle54, side51, side52);
                tvResult5.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult5.setText("Vui lòng nhập giá trị hợp lệ.");
            }
        });
    }

    public static double luongGiac(double goc, double canhKe)  {
        return Math.round(tan(goc * PI / 180) * canhKe * 1e9) / 1e9;
    }

    public static double doubleLuongGiac(double goc, double goc1, double canhKe) {
        return Math.round(canhKe / ((1 / tan(goc * PI / 180)) - (1 / tan(goc1 * PI / 180))) * 1e9) / 1e9;
    }

    public static double haigocvahaicanh(double goc, double goc1, double canh1, double canh2){
        return Math.round((canh1 / ((1 / tan(goc * PI / 180)) - (1 / tan(goc1 * PI / 180)))) + canh2 * 1e9) / 1e9;
    }

    public static double dodaibongocvamotcanh(double goc1, double goc2, double goc3, double goc4, double canh){
        double b = (canh / sin((180 - goc4 - goc1 - goc3) * PI / 180)) * sin(goc4 * PI / 180);
        double c = (canh / sin((180 - goc2 - goc3 - goc4) * PI / 180)) * sin((goc2 + goc4) * PI / 180);
        return Math.round(sqrt(b * b + c * c - 2 * b * c * cos(goc1 * PI / 180)) * 1e9) / 1e9;
    }

    public static double dodaibongocvahaicanh(double goc1, double goc2, double goc3, double goc4, double canh1, double canh2){
        double y = (canh1 / sin((180 - goc1 - goc2) * PI / 180)) * sin(goc1 * PI / 180);
        double z = (canh2 / sin((180 - goc3 - goc4) * PI / 180)) * sin(goc4 * PI / 180);
        return Math.round(sqrt(y * y + z * z - 2 * y * z * cos((180 - goc2 - goc3) * PI / 180)) * 1e9) / 1e9;
    }

}
