package com.example.phanmemtoanhoc;

import static com.example.phanmemtoanhoc.MainActivity.doubleLuongGiac;
import static com.example.phanmemtoanhoc.MainActivity.haigocvahaicanh;
import static com.example.phanmemtoanhoc.MidActivity.chuyenActivity;
import static com.example.phanmemtoanhoc.MainActivity.luongGiac;


import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

public class HeightActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.height); // Thiết lập layout tương ứng
        Button btn_back = findViewById(R.id.chieucao).findViewById(R.id.btn_back);
        btn_back.setOnClickListener(v ->{
            Intent intent = new Intent(this, MidActivity.class);
            intent.putExtra("Mode", MidActivity.MODE.HEIGHT.ordinal());
            chuyenActivity(this, intent);
        });
        // Initialize UI components for luongGiac
        TextView title1 = findViewById(R.id.title1);
        EditText etAngle1 = findViewById(R.id.et_angle1);
        EditText etSide1 = findViewById(R.id.et_side1);
        Button btnCalculate1 = findViewById(R.id.btn_calculate_method1);
        TextView tvResult1 = findViewById(R.id.tv_result_method1);

        btnCalculate1.setOnClickListener(v -> {

            try {
                double angle1 = Double.parseDouble(etAngle1.getText().toString());
                double side1 = Double.parseDouble(etSide1.getText().toString());


                double result = luongGiac(angle1, side1);
                tvResult1.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult1.setText("Vui lòng nhập giá trị hợp lệ.");
            }

        });

        // Initialize UI components for doubleLuongGiac
        TextView title2 = findViewById(R.id.title2);
        EditText etangle21 = findViewById(R.id.et_angle2_1);
        EditText etangle22 = findViewById(R.id.et_angle2_2);
        EditText etSide2 = findViewById(R.id.et_side2);
        Button btnCalculate2 = findViewById(R.id.btn_calculate_method2);
        TextView tvResult2 = findViewById(R.id.tv_result_method2);

        btnCalculate2.setOnClickListener(v -> {

            try {
                double angle21 = Double.parseDouble(etangle21.getText().toString());
                double angle22 = Double.parseDouble(etangle22.getText().toString());
                double side2 = Double.parseDouble(etSide2.getText().toString());
                double result = doubleLuongGiac(angle21, angle22, side2);
                tvResult2.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult2.setText("Vui lòng nhập giá trị hợp lệ.");
            }

        });

        // Initialize UI components for haigocvahaicanh
        TextView title3 = findViewById(R.id.title3);
        EditText etangle31 = findViewById(R.id.et_angle3_1);
        EditText etangle32 = findViewById(R.id.et_angle1_2);
        EditText etside31 = findViewById(R.id.et_side1_1);
        EditText etside32 = findViewById(R.id.et_side1_2);
        Button btnCalculate3 = findViewById(R.id.btn_calculate_method3);
        TextView tvResult3 = findViewById(R.id.tv_result_method3);

        btnCalculate3.setOnClickListener(v -> {

            try {
                double angle31 = Double.parseDouble(etangle31.getText().toString());
                double angle32 = Double.parseDouble(etangle32.getText().toString());
                double side31 = Double.parseDouble(etside31.getText().toString());
                double side32 = Double.parseDouble(etside32.getText().toString());
                double result = haigocvahaicanh(angle31, angle32, side31, side32);
                tvResult3.setText(String.format("Độ dài cạnh đối: %.9f", result));
            }
            catch (Exception e)
            {
                tvResult3.setText("Vui lòng nhập giá trị hợp lệ.");
            }

        });



        Intent intent = getIntent();
        int mode = intent.getIntExtra("Mode", 0);
        switch (mode)
        {
            case 0:
                title2.setVisibility(View.GONE);
                etangle21.setVisibility(View.GONE);
                etangle22.setVisibility(View.GONE);
                etSide2.setVisibility(View.GONE);
                btnCalculate2.setVisibility(View.GONE);
                tvResult2.setVisibility(View.GONE);

                title3.setVisibility(View.GONE);
                etangle31.setVisibility(View.GONE);
                etangle32.setVisibility(View.GONE);
                etside31.setVisibility(View.GONE);
                etside32.setVisibility(View.GONE);
                btnCalculate3.setVisibility(View.GONE);
                tvResult3.setVisibility(View.GONE);
                break;
            case 1:
                title1.setVisibility(View.GONE);
                etAngle1.setVisibility(View.GONE);
                etSide1.setVisibility(View.GONE);
                btnCalculate1.setVisibility(View.GONE);
                tvResult1.setVisibility(View.GONE);

                title3.setVisibility(View.GONE);
                etangle31.setVisibility(View.GONE);
                etangle32.setVisibility(View.GONE);
                etside31.setVisibility(View.GONE);
                etside32.setVisibility(View.GONE);
                btnCalculate3.setVisibility(View.GONE);
                tvResult3.setVisibility(View.GONE);
                break;
            case 2:
                title1.setVisibility(View.GONE);
                etAngle1.setVisibility(View.GONE);
                etSide1.setVisibility(View.GONE);
                btnCalculate1.setVisibility(View.GONE);
                tvResult1.setVisibility(View.GONE);

                title2.setVisibility(View.GONE);
                etangle21.setVisibility(View.GONE);
                etangle22.setVisibility(View.GONE);
                etSide2.setVisibility(View.GONE);
                btnCalculate2.setVisibility(View.GONE);
                tvResult2.setVisibility(View.GONE);
                break;
        }
    }
}
