package com.example.phnmmtonhc1

import android.annotation.SuppressLint
import android.os.Bundle
import android.widget.Button
import android.widget.EditText
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import kotlin.math.PI
import kotlin.math.cos
import kotlin.math.round
import kotlin.math.sin
import kotlin.math.sqrt
import kotlin.math.tan

class MainActivity : AppCompatActivity() {

    @SuppressLint("MissingInflatedId", "CutPasteId", "DefaultLocale", "SetTextI18n")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        setContentView(R.layout.content_main)

    // Initialize UI components for luongGiac
        val etAngle1 = findViewById<EditText>(R.id.et_angle1)
        val etSide1 = findViewById<EditText>(R.id.et_side1)
        val btnCalculate1 = findViewById<Button>(R.id.btn_calculate_method1)
        val tvResult1 = findViewById<TextView>(R.id.tv_result_method1)

        btnCalculate1.setOnClickListener {
            val angle1 = etAngle1.text.toString().toDoubleOrNull()
            val side1 = etSide1.text.toString().toDoubleOrNull()

            if (angle1 != null && side1 != null) {
                val result = luongGiac(angle1, side1)
                tvResult1.text = String.format("Độ dài cạnh đối: %.9f", result)
            } else {
                tvResult1.text = "Vui lòng nhập giá trị hợp lệ."
            }
        }

        // Initialize UI components for doubleLuongGiac
        val etangle21 = findViewById<EditText>(R.id.et_angle2_1)
        val etangle22 = findViewById<EditText>(R.id.et_angle2_2)
        val etSide2 = findViewById<EditText>(R.id.et_side2)
        val btnCalculate2 = findViewById<Button>(R.id.btn_calculate_method2)
        val tvResult2 = findViewById<TextView>(R.id.tv_result_method2)

        btnCalculate2.setOnClickListener {
            val angle21 = etangle21.text.toString().toDoubleOrNull()
            val angle22 = etangle22.text.toString().toDoubleOrNull()
            val side2 = etSide2.text.toString().toDoubleOrNull()

            if (angle21 != null && angle22 != null && side2 != null) {
                val result = doubleLuongGiac(angle21, angle22, side2)
                tvResult2.text = String.format("Độ dài cạnh đối: %.9f", result)
            } else {
                tvResult2.text = "Vui lòng nhập giá trị hợp lệ."
            }
        }

        // Initialize UI components for haigocvahaicanh
        val etangle31 = findViewById<EditText>(R.id.et_angle3_1)
        val etangle32 = findViewById<EditText>(R.id.et_angle1_2)
        val etside31 = findViewById<EditText>(R.id.et_side1_1)
        val etside32 = findViewById<EditText>(R.id.et_side1_2)
        val btnCalculate3 = findViewById<Button>(R.id.btn_calculate_method3)
        val tvResult3 = findViewById<TextView>(R.id.tv_result_method3)

        btnCalculate3.setOnClickListener {
            val angle31 = etangle31.text.toString().toDoubleOrNull()
            val angle32 = etangle32.text.toString().toDoubleOrNull()
            val side31 = etside31.text.toString().toDoubleOrNull()
            val side32 = etside32.text.toString().toDoubleOrNull()

            if (angle31 != null && angle32 != null && side31 != null && side32 != null) {
                val result = haigocvahaicanh(angle31, angle32, side31, side32)
                tvResult3.text = String.format("Độ dài cạnh đối: %.9f", result)
            } else {
                tvResult3.text = "Vui lòng nhập giá trị hợp lệ."
            }
        }

        // Initialize UI components for dodaibongocvamotcanh
        val etangle41 = findViewById<EditText>(R.id.et_angle4_1)
        val etangle42 = findViewById<EditText>(R.id.et_angle4_2)
        val etangle43 = findViewById<EditText>(R.id.et_angle4_3)
        val etangle44 = findViewById<EditText>(R.id.et_angle4_4)
        val etSide4 = findViewById<EditText>(R.id.et_side3)
        val btnCalculate4 = findViewById<Button>(R.id.btn_calculate_method4)
        val tvResult4 = findViewById<TextView>(R.id.tv_result_method4)

        btnCalculate4.setOnClickListener {
            val angle41 = etangle41.text.toString().toDoubleOrNull()
            val angle42 = etangle42.text.toString().toDoubleOrNull()
            val angle43 = etangle43.text.toString().toDoubleOrNull()
            val angle44 = etangle44.text.toString().toDoubleOrNull()
            val side4 = etSide4.text.toString().toDoubleOrNull()

            if (angle41 != null && angle42 != null && angle43 != null && angle44 != null && side4 != null) {
                val result = dodaibongocvamotcanh(angle41, angle42, angle43, angle44, side4)
                tvResult4.text = String.format("Độ dài cạnh đối: %.9f", result)
            } else {
                tvResult4.text = "Vui lòng nhập giá trị hợp lệ."
            }
        }

        // Initialize UI components for dodaibongocvahaicanh
        val etangle51 = findViewById<EditText>(R.id.et_angle4_1)
        val etangle52 = findViewById<EditText>(R.id.et_angle4_2)
        val etangle53 = findViewById<EditText>(R.id.et_angle4_3)
        val etangle54 = findViewById<EditText>(R.id.et_angle4_4)
        val etside51 = findViewById<EditText>(R.id.et_side4_1)
        val etside52 = findViewById<EditText>(R.id.et_side4_2)
        val btnCalculate5 = findViewById<Button>(R.id.btn_calculate_method5)
        val tvResult5 = findViewById<TextView>(R.id.tv_result_method5)

        btnCalculate5.setOnClickListener {
            val angle51 = etangle51.text.toString().toDoubleOrNull()
            val angle52 = etangle52.text.toString().toDoubleOrNull()
            val angle53 = etangle53.text.toString().toDoubleOrNull()
            val angle54 = etangle54.text.toString().toDoubleOrNull()
            val side51 = etside51.text.toString().toDoubleOrNull()
            val side52 = etside52.text.toString().toDoubleOrNull()

            if (angle51 != null && angle52 != null && angle53 != null && angle54 != null && side51 != null && side52 != null) {
                val result = dodaibongocvahaicanh(angle51, angle52, angle53, angle54, side51, side52)
                tvResult5.text = String.format("Độ dài cạnh đối: %.9f", result)
            } else {
                tvResult5.text = "Vui lòng nhập giá trị hợp lệ."
            }
        }
    }

    private fun luongGiac(goc: Double, canhKe: Double): Double {
        return round(tan(goc * PI / 180) * canhKe * 1e9) / 1e9
    }

    private fun doubleLuongGiac(goc: Double, goc1: Double, canhKe: Double): Double {
        return round(canhKe / ((1 / tan(goc * PI / 180)) - (1 / tan(goc1 * PI / 180))) * 1e9) / 1e9
    }

    private fun haigocvahaicanh(goc: Double, goc1: Double, canh1: Double, canh2: Double): Double {
        return round((canh1 / ((1 / tan(goc * PI / 180)) - (1 / tan(goc1 * PI / 180)))) + canh2 * 1e9) / 1e9
    }

    private fun dodaibongocvamotcanh(goc1: Double, goc2: Double, goc3: Double, goc4: Double, canh: Double): Double {
        val b = (canh / sin((180 - goc4 - goc1 - goc3) * PI / 180)) * sin(goc4 * PI / 180)
        val c = (canh / sin((180 - goc2 - goc3 - goc4) * PI / 180)) * sin((goc2 + goc4) * PI / 180)
        return round(sqrt(b * b + c * c - 2 * b * c * cos(goc1 * PI / 180)) * 1e9) / 1e9
    }

    private fun dodaibongocvahaicanh(goc1: Double, goc2: Double, goc3: Double, goc4: Double, canh1: Double, canh2: Double): Double {
        val y = (canh1 / sin((180 - goc1 - goc2) * PI / 180)) * sin(goc1 * PI / 180)
        val z = (canh2 / sin((180 - goc3 - goc4) * PI / 180)) * sin(goc4 * PI / 180)
        return round(sqrt(y * y + z * z - 2 * y * z * cos((180 - goc2 - goc3) * PI / 180)) * 1e9) / 1e9
    }

}
