/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.treeharvester_common_forge.config.ConfigHandler;
import com.natamus.treeharvester_common_forge.data.Variables;
import com.natamus.treeharvester_common_forge.processing.LeafProcessing;
import com.natamus.treeharvester_common_forge.processing.TreeProcessing;
import com.natamus.treeharvester_common_forge.util.Util;
import java.util.Date;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TreeCutEvents {
    public static boolean onTreeHarvest(Level level, Player player, BlockPos bpos, BlockState state, BlockEntity blockEntity) {
        int logcount;
        Block block;
        if (level.f_46443_) {
            return true;
        }
        Pair cachepair = new Pair((Object)level, (Object)player);
        if (!Variables.harvestSpeedCache.containsKey(cachepair)) {
            if (ConfigHandler.treeHarvestWithoutSneak ? player.m_6047_() : !player.m_6047_()) {
                return true;
            }
        } else {
            Variables.harvestSpeedCache.remove(cachepair);
        }
        if (!Util.isTreeLog(block = level.m_8055_(bpos).m_60734_())) {
            return true;
        }
        ItemStack hand = player.m_21120_(InteractionHand.MAIN_HAND);
        Item handitem = hand.m_41720_();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return true;
            }
            if (!Variables.allowedAxes.contains(handitem)) {
                return true;
            }
        }
        if (ConfigHandler.automaticallyFindBottomBlock) {
            BlockPos temppos = bpos.m_7949_();
            while (level.m_8055_(temppos.m_7495_()).m_60734_().equals(block)) {
                temppos = temppos.m_7495_().m_7949_();
            }
            for (BlockPos belowpos : BlockPos.m_121976_((int)(temppos.m_123341_() - 1), (int)(temppos.m_123342_() - 1), (int)(temppos.m_123343_() - 1), (int)(temppos.m_123341_() + 1), (int)(temppos.m_123342_() - 1), (int)(temppos.m_123343_() + 1))) {
                if (!level.m_8055_(belowpos).m_60734_().equals(block)) continue;
                temppos = belowpos.m_7949_();
                while (level.m_8055_(temppos.m_7495_()).m_60734_().equals(block)) {
                    temppos = temppos.m_7495_().m_7949_();
                }
                break block1;
            }
            bpos = temppos.m_7949_();
        }
        if ((logcount = TreeProcessing.isTreeAndReturnLogAmount(level, bpos)) < 0) {
            return true;
        }
        int durabilitylosecount = (int)Math.ceil(1.0 / ConfigHandler.loseDurabilityModifier);
        int durabilitystartcount = -1;
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos highestLogPos = bpos.m_7949_();
        List<BlockPos> logsToBreak = TreeProcessing.getAllLogsToBreak(level, bpos, logcount, block);
        for (BlockPos logpos : logsToBreak) {
            if (logpos.m_123342_() > highestLogPos.m_123342_()) {
                highestLogPos = logpos.m_7949_();
            }
            BlockState logstate = level.m_8055_(logpos);
            Block log = logstate.m_60734_();
            BlockFunctions.dropBlock((Level)level, (BlockPos)logpos);
            if (player.m_7500_()) continue;
            if (ConfigHandler.loseDurabilityPerHarvestedLog) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)hand, (ServerPlayer)serverPlayer, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
                } else if (--durabilitylosecount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)hand, (ServerPlayer)serverPlayer, (InteractionHand)InteractionHand.MAIN_HAND, (int)1);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!ConfigHandler.increaseExhaustionPerHarvestedLog) continue;
            player.m_36399_(0.025f * (float)ConfigHandler.increaseExhaustionModifier);
        }
        LeafProcessing.breakTreeLeaves(level, logsToBreak, bpos, highestLogPos);
        return logsToBreak.size() == 0;
    }

    public static float onHarvestBreakSpeed(Level level, Player player, float digSpeed, BlockState state) {
        if (!ConfigHandler.increaseHarvestingTimePerLog) {
            return digSpeed;
        }
        Block block = state.m_60734_();
        if (!Util.isTreeLog(block)) {
            return digSpeed;
        }
        if (ConfigHandler.treeHarvestWithoutSneak ? player.m_6047_() : !player.m_6047_()) {
            return digSpeed;
        }
        ItemStack hand = player.m_21120_(InteractionHand.MAIN_HAND);
        Item handitem = hand.m_41720_();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return digSpeed;
            }
            if (!Variables.allowedAxes.contains(handitem)) {
                return digSpeed;
            }
        }
        int logcount = -1;
        Date now = new Date();
        Pair keypair = new Pair((Object)level, (Object)player);
        if (Variables.harvestSpeedCache.containsKey(keypair)) {
            Pair<Date, Integer> valuepair = Variables.harvestSpeedCache.get(keypair);
            long ms = now.getTime() - ((Date)valuepair.getFirst()).getTime();
            if (ms < 1000L) {
                logcount = (Integer)valuepair.getSecond();
            } else {
                Variables.harvestSpeedCache.remove(keypair);
            }
        }
        BlockPos bpos = null;
        HitResult hitResult = player.m_19907_(20.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            bpos = ((BlockHitResult)hitResult).m_82425_();
        }
        if (bpos == null) {
            return digSpeed;
        }
        boolean recheck = false;
        if (logcount < 0) {
            if (TreeProcessing.isTreeAndReturnLogAmount(level, bpos) < 0) {
                return digSpeed;
            }
            logcount = TreeProcessing.isTreeAndReturnLogAmount(level, bpos);
            if (logcount == 0) {
                return digSpeed;
            }
            Variables.harvestSpeedCache.put((Pair<Level, Player>)keypair, (Pair<Date, Integer>)new Pair((Object)now, (Object)logcount));
            recheck = true;
        }
        return digSpeed / (1.0f + (float)logcount * (float)ConfigHandler.increasedHarvestingTimePerLogModifier);
    }
}

