/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public class PlayerSoundPacket
extends SoundPacket<PlayerSoundPacket> {
    protected boolean whispering;
    protected float distance;

    public PlayerSoundPacket(UUID channelId, UUID sender, byte[] data, long sequenceNumber, boolean whispering, float distance, @Nullable String category) {
        super(channelId, sender, data, sequenceNumber, category);
        this.whispering = whispering;
        this.distance = distance;
    }

    public PlayerSoundPacket(UUID channelId, UUID sender, short[] data, boolean whispering, float distance, @Nullable String category) {
        super(channelId, sender, data, category);
        this.whispering = whispering;
        this.distance = distance;
    }

    public PlayerSoundPacket() {
    }

    @Override
    public UUID getSender() {
        return this.sender;
    }

    public boolean isWhispering() {
        return this.whispering;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public PlayerSoundPacket fromBytes(FriendlyByteBuf buf) {
        PlayerSoundPacket soundPacket = new PlayerSoundPacket();
        soundPacket.channelId = buf.m_130259_();
        soundPacket.sender = buf.m_130259_();
        soundPacket.data = buf.m_130052_();
        soundPacket.sequenceNumber = buf.readLong();
        soundPacket.distance = buf.readFloat();
        byte data = buf.readByte();
        soundPacket.whispering = this.hasFlag(data, (byte)1);
        if (this.hasFlag(data, (byte)2)) {
            soundPacket.category = buf.m_130136_(16);
        }
        return soundPacket;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.channelId);
        buf.m_130077_(this.sender);
        buf.m_130087_(this.data);
        buf.writeLong(this.sequenceNumber);
        buf.writeFloat(this.distance);
        byte data = 0;
        if (this.whispering) {
            data = this.setFlag(data, (byte)1);
        }
        if (this.category != null) {
            data = this.setFlag(data, (byte)2);
        }
        buf.writeByte((int)data);
        if (this.category != null) {
            buf.m_130072_(this.category, 16);
        }
    }
}

