/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core;

import com.codinglitch.simpleradio.core.ItemsEnabledCondition;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundRadioPacket;
import com.codinglitch.simpleradio.core.networking.packets.ServerboundRadioUpdatePacket;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlockEntities;
import com.codinglitch.simpleradio.core.registry.SimpleRadioBlocks;
import com.codinglitch.simpleradio.core.registry.SimpleRadioItems;
import com.codinglitch.simpleradio.core.registry.SimpleRadioMenus;
import com.codinglitch.simpleradio.datagen.SimpleRadioRecipeProvider;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.util.TriConsumer;

@Mod.EventBusSubscriber(modid="simpleradio", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeLoader {
    private static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("simpleradio", "channel"), () -> "0", "0"::equals, "0"::equals);

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new SimpleRadioRecipeProvider(generator.getPackOutput()));
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ITEMS, helper -> SimpleRadioItems.ITEMS.forEach((location, itemHolder) -> helper.register(location, (Object)itemHolder.get())));
        event.register(ForgeRegistries.Keys.BLOCKS, helper -> SimpleRadioBlocks.BLOCKS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> SimpleRadioBlockEntities.BLOCK_ENTITIES.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> SimpleRadioMenus.MENUS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(Registries.f_279569_, helper -> SimpleRadioMenus.CREATIVE_TABS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> CraftingHelper.register((IConditionSerializer)ItemsEnabledCondition.Serializer.INSTANCE));
    }

    public static void loadPackets() {
        int index = 0;
        CHANNEL.messageBuilder(ServerboundRadioUpdatePacket.class, index++).decoder(ServerboundRadioUpdatePacket::decode).encoder(ServerboundRadioUpdatePacket::encode).consumerMainThread(ForgeLoader.serverbound(ServerboundRadioUpdatePacket::handle)).add();
        CHANNEL.messageBuilder(ClientboundRadioPacket.class, index++).decoder(ClientboundRadioPacket::decode).encoder(ClientboundRadioPacket::encode).consumerMainThread(ForgeLoader.clientbound(ClientboundRadioPacket::handle)).add();
    }

    private static <P> BiConsumer<P, Supplier<NetworkEvent.Context>> serverbound(TriConsumer<P, MinecraftServer, ServerPlayer> consumer) {
        return (packet, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            consumer.accept(packet, (Object)context.getSender().m_20194_(), (Object)context.getSender());
            context.setPacketHandled(true);
        };
    }

    public static <P> BiConsumer<P, Supplier<NetworkEvent.Context>> clientbound(Consumer<P> consumer) {
        return (packet, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            consumer.accept(packet);
            context.setPacketHandled(true);
        };
    }

    public static void loadItems() {
    }

    public static void load() {
        ForgeLoader.loadItems();
        ForgeLoader.loadPackets();
    }

    public static void loadClient() {
    }
}

