/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.compat.VibrativeCompat;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioChannel;
import com.codinglitch.simpleradio.radio.RadioSource;

public class CompatCore {
    public static boolean VC_INTERACTION = false;
    public static boolean VIBRATIVE_VOICE = false;
    public static boolean VALKYRIEN_SKIES = false;

    public static void spoutCompatibilities() {
        if (Services.PLATFORM.isModLoaded("vcinteraction")) {
            CommonSimpleRadio.info("Voice Chat Interaction is present!", new Object[0]);
            if (SimpleRadioLibrary.SERVER_CONFIG.compatibilities.voice_chat_interaction.enabled.booleanValue()) {
                VC_INTERACTION = true;
                CommonSimpleRadio.info("..and compat is enabled!", new Object[0]);
            } else {
                CommonSimpleRadio.info("..but compat is disabled", new Object[0]);
            }
        }
        if (Services.PLATFORM.isModLoaded("vibrativevoice")) {
            CommonSimpleRadio.info("Vibrative Voice is present!", new Object[0]);
            if (Services.PLATFORM.isModLoaded("vcinteraction")) {
                CommonSimpleRadio.info("..but so is Voice Chat Interaction?!", new Object[0]);
            } else if (SimpleRadioLibrary.SERVER_CONFIG.compatibilities.vibrative_voice.enabled.booleanValue()) {
                VIBRATIVE_VOICE = true;
                CommonSimpleRadio.info("..and compat is enabled!", new Object[0]);
            } else {
                CommonSimpleRadio.info("..but compat is disabled", new Object[0]);
            }
        }
        if (Services.PLATFORM.isModLoaded("valkyrienskies")) {
            CommonSimpleRadio.info("Valkyrien Skies is present!", new Object[0]);
            if (SimpleRadioLibrary.SERVER_CONFIG.compatibilities.valkyrien_skies.enabled.booleanValue()) {
                VALKYRIEN_SKIES = true;
                CommonSimpleRadio.info("..and compat is enabled!", new Object[0]);
            } else {
                CommonSimpleRadio.info("..but compat is disabled", new Object[0]);
            }
        }
    }

    public static void reloadCompatibilities() {
        CommonSimpleRadio.info("Reloading compatibilities!", new Object[0]);
        CompatCore.spoutCompatibilities();
    }

    public static void onData(RadioChannel channel, RadioSource source, short[] decoded) {
        if (VIBRATIVE_VOICE) {
            VibrativeCompat.onData(channel, source, decoded);
        }
    }
}

