/*
 * Decompiled with CFR 0.152.
 */
package umpaz.farmersrespite.client.gui;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class KettleTooltip
implements ClientTooltipComponent {
    private static final int ITEM_SIZE = 16;
    private static final int MARGIN = 4;
    private final int textSpacing;
    private final FluidStack mealStack;

    public KettleTooltip(KettleTooltipComponent tooltip) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.textSpacing = 9 + 1;
        this.mealStack = tooltip.mealStack;
    }

    public int m_142103_() {
        return this.mealStack.isEmpty() ? this.textSpacing : this.textSpacing + 16;
    }

    public int m_142069_(Font font) {
        if (!this.mealStack.isEmpty()) {
            MutableComponent textServingsOf = this.mealStack.getAmount() == 250 ? TextUtils.getTranslation((String)"tooltip.cooking_pot.single_serving", (Object[])new Object[0]) : TextUtils.getTranslation((String)"tooltip.cooking_pot.many_servings", (Object[])new Object[]{this.mealStack.getAmount() / 250});
            return Math.max(font.m_92852_((FormattedText)textServingsOf), font.m_92852_((FormattedText)this.mealStack.getDisplayName()) + 20);
        }
        return font.m_92852_((FormattedText)TextUtils.getTranslation((String)"tooltip.cooking_pot.empty", (Object[])new Object[0]));
    }

    public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics gui) {
        if (this.mealStack.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)this.mealStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(this.mealStack);
        if (stillTexture == null) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(this.mealStack);
        float alpha = (float)(tintColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(tintColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(tintColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(tintColor & 0xFF) / 255.0f;
        gui.m_280565_(mouseX, mouseY + 9, 0, 16, 16, sprite, red, green, blue, alpha);
    }

    public void m_142440_(Font font, int x, int y, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        int gray;
        Integer color = ChatFormatting.GRAY.m_126665_();
        int n = gray = color == null ? -1 : color;
        if (!this.mealStack.isEmpty()) {
            MutableComponent textServingsOf = this.mealStack.getAmount() == 250 ? TextUtils.getTranslation((String)"tooltip.cooking_pot.single_serving", (Object[])new Object[0]) : TextUtils.getTranslation((String)"tooltip.cooking_pot.many_servings", (Object[])new Object[]{this.mealStack.getAmount() / 250});
            font.m_272077_((Component)textServingsOf, (float)x, (float)y, gray, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            font.m_272077_(this.mealStack.getDisplayName(), (float)(x + 16 + 4), (float)(y + this.textSpacing + 4), -1, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        } else {
            MutableComponent textEmpty = TextUtils.getTranslation((String)"tooltip.cooking_pot.empty", (Object[])new Object[0]);
            font.m_272077_((Component)textEmpty, (float)x, (float)y, gray, true, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public record KettleTooltipComponent(FluidStack mealStack) implements TooltipComponent
    {
    }
}

