/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.event;

import com.eccarrascon.structurecredits.StructureCreditsClient;
import com.eccarrascon.structurecredits.registry.KeyMapRegistry;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class DisplayNameClient
implements ClientTickEvent.Client {
    private static String lastStructure = "haley:you_found_it!";

    public void tick(Minecraft instance) {
        KeyMapRegistry keyMapRegistry = KeyMapRegistry.getInstance();
        while (keyMapRegistry.getDeactivateMsgKeyMapping().m_90859_()) {
            this.toggleActiveState();
        }
        while (keyMapRegistry.getShowAgainMsgKeyMapping().m_90859_()) {
            this.showLastStructureMessage();
        }
        while (keyMapRegistry.getDontShowMsgKeyMapping().m_90859_()) {
            this.addCurrentStructureToDontShow();
        }
    }

    public static void updateStructureName(String structureName, boolean isPacket) {
        block5: {
            String structureNameFormatted;
            String modName;
            block6: {
                if (Objects.equals(lastStructure, structureName) && isPacket) {
                    return;
                }
                if (!StructureCreditsClient.CONFIG_VALUES.isActive() && isPacket) break block5;
                lastStructure = structureName;
                String customName = StructureCreditsClient.CONFIG_VALUES.getCustomStructureName().getOrDefault(structureName, structureName);
                String[] parts = customName.split(":");
                if (parts.length != 2) break block5;
                modName = DisplayNameClient.formatName(parts[0]);
                structureNameFormatted = DisplayNameClient.formatName(parts[1]);
                if (!isPacket) break block6;
                if (!StructureCreditsClient.CONFIG_VALUES.getDontShowAll().stream().noneMatch(structureName::startsWith) || StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(structureName)) break block5;
            }
            String messageKey = StructureCreditsClient.CONFIG_VALUES.isShowCreator() ? "text.structurecredits.message" : "text.structurecredits.message_no_creator";
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)messageKey, (Object[])new Object[]{structureNameFormatted, modName}), !StructureCreditsClient.CONFIG_VALUES.isChatMessage());
            if (isPacket && StructureCreditsClient.CONFIG_VALUES.isOnlyOneTime() && !StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(structureName)) {
                StructureCreditsClient.CONFIG_VALUES.getDontShow().add(structureName);
                StructureCreditsClient.CONFIG.save();
            }
        }
    }

    private static String formatName(String name) {
        return Arrays.stream(name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    private void toggleActiveState() {
        boolean isActive = !StructureCreditsClient.CONFIG_VALUES.isActive();
        StructureCreditsClient.CONFIG_VALUES.setActive(isActive);
        StructureCreditsClient.CONFIG.save();
        String messageKey = isActive ? "text.structurecredits.activated" : "text.structurecredits.deactivated";
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)messageKey), true);
    }

    private void showLastStructureMessage() {
        if (lastStructure != null) {
            DisplayNameClient.updateStructureName(lastStructure, false);
        }
    }

    private void addCurrentStructureToDontShow() {
        if (lastStructure != null) {
            if (!StructureCreditsClient.CONFIG_VALUES.getDontShow().contains(lastStructure)) {
                StructureCreditsClient.CONFIG_VALUES.getDontShow().add(lastStructure);
                StructureCreditsClient.CONFIG.save();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.dont_show"), true);
            } else {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"text.structurecredits.already_dont_show"), true);
            }
        }
    }
}

