/*
 * Decompiled with CFR 0.152.
 */
package com.eccarrascon.structurecredits.event;

import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.eccarrascon.structurecredits.StructureCredits;
import com.eccarrascon.structurecredits.network.StructureNameSyncMessage;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.GameInstance;
import java.util.List;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class DetectStructure
implements TickEvent.Player {
    private int ticksSinceCheck = 0;
    private ResourceKey<Structure> actualStructure;
    private String actualDimensionalStructure;

    public static ServerLevel getServerLevel(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel;
        }
        MinecraftServer server = GameInstance.getServer();
        return server == null ? null : server.m_129880_(level.m_46472_());
    }

    public void tick(Player player) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (StructureCredits.DIMD_COMPAT && DungeonUtils.isDimensionDungeon((Level)player.m_9236_())) {
            this.handleDimensionalDungeonDetection(player);
        } else {
            ++this.ticksSinceCheck;
            if (this.ticksSinceCheck >= 20) {
                this.ticksSinceCheck = 0;
                this.isPlayerInAnyStructure(player, DetectStructure.getServerLevel(player.m_9236_()), player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
        }
    }

    private void handleDimensionalDungeonDetection(Player player) {
        DungeonRoom room = DungeonData.get((Level)player.m_9236_()).getRoomAtPos(player.m_146902_());
        if (!(room == null || this.actualDimensionalStructure != null && this.actualDimensionalStructure.equals(room.structure))) {
            this.actualDimensionalStructure = room.structure;
            new StructureNameSyncMessage(room.structure).sendTo((ServerPlayer)player);
        }
    }

    public void isPlayerInAnyStructure(Player player, ServerLevel level, double x, double y, double z) {
        if (this.actualStructure != null && LocationPredicate.m_220589_(this.actualStructure).m_52617_(level, x, y, z)) {
            return;
        }
        this.actualStructure = null;
        ChunkPos playerChunkPos = new ChunkPos((int)x >> 4, (int)z >> 4);
        List structuresInChunk = level.m_215010_().m_220477_(playerChunkPos, predicate -> true);
        for (StructureStart structure : structuresInChunk) {
            ResourceKey structureFound = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)structure.m_226861_()));
            if (!LocationPredicate.m_220589_((ResourceKey)structureFound).m_52617_(level, x, y, z)) continue;
            this.actualStructure = structureFound;
            new StructureNameSyncMessage(structureFound.m_135782_().toString()).sendTo((ServerPlayer)player);
            break;
        }
    }
}

