/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;

public class WhiteMoonEvent
extends LunarEvent {
    public WhiteMoonEvent() {
        super(new ResourceLocation("lunar", "white_moon"), 0x1F1F1F);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getWhiteMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.white_moon";
    }

    @Override
    public boolean applyPlayerEffect() {
        return true;
    }

    @Override
    public boolean dictatesMobSpawn() {
        return true;
    }

    @Override
    public EventResult getSpawnResult(LivingEntity livingEntity, MobSpawnType spawnType) {
        if (spawnType == MobSpawnType.NATURAL && livingEntity.m_6095_().m_20674_() == MobCategory.MONSTER) {
            return EventResult.DENY;
        }
        return EventResult.ALLOW;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        return EventResult.DEFAULT;
    }
}

