/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class TinyMoonEvent
extends LunarEvent {
    public TinyMoonEvent() {
        super(new ResourceLocation("lunar", "tiny_moon"), 0xFFFFF1);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getTinyMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.tiny_moon";
    }

    @Override
    public boolean applyPlayerEffect() {
        return true;
    }

    @Override
    public void applyEntityEffect(Entity entity) {
        Vec3 deltaMovement = entity.m_20184_();
        entity.m_20256_(deltaMovement.m_82520_(0.0, -1.0, 0.0));
    }

    @Override
    public boolean applyEntityEffect() {
        return true;
    }

    @Override
    public void applyPlayerEffect(Player player) {
        if (!player.m_9236_().f_46443_) {
            Services.PLATFORM.syncDeltaMovement((ServerPlayer)player, player.m_20184_());
        }
    }

    @Override
    public float moonScale() {
        return 0.25f;
    }

    @Override
    public EventResult canSleep(Player player, BlockPos sleepingLocation) {
        return EventResult.DEFAULT;
    }
}

