/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.network.message;

import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.client.MoonHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncEventMessage {
    private final int color;
    private final String eventID;
    private final float moonScale;
    private final ResourceLocation customTexture;

    public SyncEventMessage(ILunarEvent event) {
        this.color = event != null ? event.moonColor() : -1;
        this.eventID = event != null ? event.getID().toString() : "";
        this.moonScale = event != null ? event.moonScale() : 1.0f;
        this.customTexture = event != null ? event.moonTexture() : null;
    }

    public SyncEventMessage(int color, String eventName, float scale, String moonTexture) {
        this.color = color;
        this.eventID = eventName;
        this.moonScale = scale;
        this.customTexture = moonTexture != null && moonTexture.isEmpty() ? null : ResourceLocation.m_135820_((String)moonTexture);
    }

    public static SyncEventMessage decode(FriendlyByteBuf buffer) {
        return new SyncEventMessage(buffer.readInt(), buffer.m_130277_(), buffer.readFloat(), buffer.m_130277_());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
        buffer.m_130070_(this.eventID);
        buffer.writeFloat(this.moonScale);
        buffer.m_130070_(this.customTexture == null ? "" : this.customTexture.toString());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                UpdateEvent.update(this.eventID, this.color, this.moonScale, this.customTexture).run();
            }
        });
        ctx.setPacketHandled(true);
    }

    private static class UpdateEvent {
        private UpdateEvent() {
        }

        private static DistExecutor.SafeRunnable update(final String eventID, final int moonColor, final float moonScale, final ResourceLocation customTexture) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    if (moonColor == -1 || eventID.isBlank()) {
                        MoonHandler.disableMoon();
                    } else {
                        MoonHandler.setMoon(eventID, moonColor, moonScale);
                        if (customTexture != null) {
                            MoonHandler.setMoonTexture(customTexture);
                        }
                    }
                }
            };
        }
    }
}

