/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SyncDeltaMovement {
    private final Vec3 deltaMovement;

    public SyncDeltaMovement(Vec3 deltaMovement) {
        this.deltaMovement = deltaMovement;
    }

    public static SyncDeltaMovement decode(FriendlyByteBuf buffer) {
        return new SyncDeltaMovement(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.deltaMovement.f_82479_);
        buffer.writeDouble(this.deltaMovement.f_82480_);
        buffer.writeDouble(this.deltaMovement.f_82481_);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isClient()) {
                UpdateEvent.update(this.deltaMovement).run();
            }
        });
        ctx.setPacketHandled(true);
    }

    private static class UpdateEvent {
        private UpdateEvent() {
        }

        private static DistExecutor.SafeRunnable update(final Vec3 deltaMovement) {
            return new DistExecutor.SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Minecraft.m_91087_().f_91074_.m_20256_(deltaMovement);
                }
            };
        }
    }
}

