/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.registry.LunarRegistry;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class LunarCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"lunar");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82127_((String)"forceEvent").then(Commands.m_82129_((String)"eventID", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((cs, builder) -> SharedSuggestionProvider.m_82970_(LunarRegistry.instance().getIDList(), (SuggestionsBuilder)builder)).executes(LunarCommands::forceEvent)));
        dispatcher.register(root);
    }

    private static int forceEvent(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation eventID = ResourceLocationArgument.m_107011_(ctx, (String)"eventID");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81377_().m_129880_(Level.f_46428_);
        LunarPhaseData phaseData = LunarPhaseData.get((Level)level);
        ILunarEvent event = LunarRegistry.instance().getEventByID(eventID);
        phaseData.setForcedEvent(event);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Successfully forced a " + I18n.m_118938_((String)event.getTranslationKey(), (Object[])new Object[0]) + " moon next night")), true);
        return 0;
    }
}

