/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.world.data;

import com.lgow.endofherobrine.world.spawner.SpawnerData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class ModSavedData
extends SavedData {
    private final Map<String, SpawnerData> spawnerDataMap = new HashMap<String, SpawnerData>();
    private boolean hasDefeatedHerobrine;
    private boolean herobrineIsDead;
    private boolean apocalypseMode;
    private int herobrineRestTimer;
    private int lastLetterIndex;

    public static ModSavedData get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        return (ModSavedData)level.m_8895_().m_164861_(nbt -> new ModSavedData().read((CompoundTag)nbt), ModSavedData::new, "endofherobrine");
    }

    public SpawnerData getSpawnerData(String key) {
        return this.spawnerDataMap.computeIfAbsent(key, s -> new SpawnerData(this));
    }

    public boolean hasDefeatedHerobrine() {
        return this.hasDefeatedHerobrine;
    }

    public void setHasDefeatedHerobrine(boolean b) {
        this.hasDefeatedHerobrine = b;
        this.m_77762_();
    }

    public int getHerobrineRestTimer() {
        return this.herobrineRestTimer;
    }

    public void setHerobrineRestTimer(int b) {
        this.herobrineRestTimer = b;
        this.m_77762_();
    }

    public void setHerobrineIsDead(boolean b) {
        this.herobrineIsDead = b;
        this.m_77762_();
    }

    public boolean isApocalypseMode() {
        return this.apocalypseMode;
    }

    public void setApocalypseMode(boolean b) {
        this.apocalypseMode = b;
        this.m_77762_();
    }

    public boolean herobrineIsDead() {
        return this.herobrineIsDead;
    }

    public boolean isHerobrineDeadOrResting() {
        return this.herobrineIsDead || this.herobrineRestTimer > 0;
    }

    public ModSavedData read(CompoundTag nbt) {
        if (nbt.m_128425_("HerobrineSpawnDelay", 3)) {
            this.getSpawnerData("Herobrine").setSpawnDelay(nbt.m_128451_("HerobrineSpawnDelay"));
        }
        if (nbt.m_128425_("HerobrineSpawnChance", 3)) {
            this.getSpawnerData("Herobrine").setSpawnChance(nbt.m_128451_("HerobrineSpawnChance"));
        }
        if (nbt.m_128425_("SpawnData", 9)) {
            this.spawnerDataMap.clear();
            ListTag list = nbt.m_128437_("SpawnData", 10);
            list.forEach(tag -> {
                CompoundTag nbtTag = (CompoundTag)tag;
                String key = nbtTag.m_128461_("Key");
                SpawnerData data = new SpawnerData(this);
                data.read(nbtTag);
                this.spawnerDataMap.put(key, data);
            });
        }
        if (nbt.m_128425_("ApocalypseMode", 1)) {
            this.apocalypseMode = nbt.m_128471_("ApocalypseMode");
        }
        if (nbt.m_128425_("HasDefeatedHerobrine", 1)) {
            this.hasDefeatedHerobrine = nbt.m_128471_("HasDefeatedHerobrine");
        }
        if (nbt.m_128425_("HerobrineIsDead", 1)) {
            this.herobrineIsDead = nbt.m_128471_("HerobrineIsDead");
        }
        if (nbt.m_128425_("HerobrineRestTimer", 3)) {
            this.herobrineRestTimer = nbt.m_128451_("HerobrineRestTimer");
        }
        if (nbt.m_128425_("LastLetterIndex", 3)) {
            this.lastLetterIndex = nbt.m_128451_("LastLetterIndex");
        }
        return this;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag spawnDataList = new ListTag();
        this.spawnerDataMap.forEach((s, data) -> {
            CompoundTag key = new CompoundTag();
            data.write(key);
            key.m_128359_("Key", s);
            spawnDataList.add((Object)key);
        });
        nbt.m_128365_("SpawnData", (Tag)spawnDataList);
        nbt.m_128379_("ApocalypseMode", this.apocalypseMode);
        nbt.m_128379_("HasDefeatedHerobrine", this.hasDefeatedHerobrine);
        nbt.m_128379_("HerobrineIsDead", this.herobrineIsDead);
        nbt.m_128405_("HerobrineRestTimer", this.herobrineRestTimer);
        nbt.m_128405_("LastLetterIndex", this.lastLetterIndex);
        return nbt;
    }

    public int getLastLetterIndex() {
        return this.lastLetterIndex;
    }

    public void updateLastLetterIndex() {
        this.lastLetterIndex = this.lastLetterIndex >= 8 ? 0 : ++this.lastLetterIndex;
        this.m_77762_();
    }
}

