/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.util;

import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.entity.EntityInit;
import com.lgow.endofherobrine.entity.herobrine.AbstractHerobrine;
import com.lgow.endofherobrine.entity.possessed.PosZombieVillager;
import com.lgow.endofherobrine.entity.possessed.animal.PosPig;
import com.lgow.endofherobrine.entity.possessed.animal.PosRabbit;
import com.lgow.endofherobrine.entity.possessed.animal.PosSheep;
import com.lgow.endofherobrine.entity.possessed.animal.PosVillager;
import com.lgow.endofherobrine.world.data.ModSavedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ModUtil {
    public static Random random = new Random();
    private static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> animalPossessionList = Map.of(EntityType.f_20555_, (EntityType)EntityInit.P_CHICKEN.get(), EntityType.f_20557_, (EntityType)EntityInit.P_COW.get(), EntityType.f_20510_, (EntityType)EntityInit.P_PIG.get(), EntityType.f_20517_, (EntityType)EntityInit.P_RABBIT.get(), EntityType.f_20520_, (EntityType)EntityInit.P_SHEEP.get(), EntityType.f_20492_, (EntityType)EntityInit.P_VILlAGER.get());
    private static final Map<EntityType<? extends Monster>, EntityType<? extends Monster>> monsterPossessionList = Map.of(EntityType.f_20458_, (EntityType)EntityInit.P_HUSK.get(), EntityType.f_20523_, (EntityType)EntityInit.P_SILVERFISH.get(), EntityType.f_20524_, (EntityType)EntityInit.P_SKELETON.get(), EntityType.f_20481_, (EntityType)EntityInit.P_STRAY.get(), EntityType.f_20501_, (EntityType)EntityInit.P_ZOMBIE.get(), EntityType.f_20530_, (EntityType)EntityInit.P_ZOMBIE_VILLAGER.get());
    public static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> possessionList = Stream.concat(animalPossessionList.entrySet().stream(), monsterPossessionList.entrySet().stream()).collect(HashMap::new, (map, entry) -> map.put((EntityType)entry.getKey(), (EntityType)entry.getValue()), HashMap::putAll);
    public static final Map<EntityType<? extends Mob>, EntityType<? extends Mob>> reversionList = possessionList.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((EntityType)entry.getValue(), (EntityType)entry.getKey()), HashMap::putAll);

    public static void spawnHerobrine(AbstractHerobrine herobrine, ServerLevel server, Direction dir, Vec3 pos, double offs) {
        switch (dir) {
            case NORTH: {
                herobrine.m_146884_(pos.m_82492_(0.0, 0.0, offs));
                break;
            }
            case SOUTH: {
                herobrine.m_146884_(pos.m_82520_(0.0, 0.0, offs));
                break;
            }
            case EAST: {
                herobrine.m_146884_(pos.m_82520_(offs, 0.0, 0.0));
                break;
            }
            case WEST: {
                herobrine.m_146884_(pos.m_82492_(offs, 0.0, 0.0));
            }
        }
        server.m_7967_((Entity)herobrine);
    }

    public static void possessMob(Mob mob, ServerLevel level, boolean isAngry, boolean affectMonsters) {
        Mob posMob;
        EntityType type = mob.m_6095_();
        if (ConfigHandler.shouldDoMobPossession() && !ConfigHandler.shouldPreventPossession(type) && animalPossessionList.containsKey(type)) {
            posMob = mob.m_21406_(animalPossessionList.get(mob.m_6095_()), true);
            if (type.equals(EntityType.f_20510_)) {
                if (((Pig)mob).m_6254_()) {
                    ((PosPig)posMob).m_5853_(null);
                }
            } else if (type.equals(EntityType.f_20517_)) {
                ((PosRabbit)posMob).m_28464_(((Rabbit)mob).m_28554_());
            } else if (type.equals(EntityType.f_20520_)) {
                ((PosSheep)posMob).m_29855_(((Sheep)mob).m_29874_());
                ((PosSheep)posMob).m_29878_(((Sheep)mob).m_29875_());
            } else if (type.equals(EntityType.f_20492_)) {
                ((PosVillager)posMob).m_34375_(((Villager)mob).m_7141_());
                ((PosVillager)posMob).m_35476_(((Villager)mob).m_6616_());
                ((PosVillager)posMob).m_35546_(((Villager)mob).m_7809_());
            }
            if (isAngry) {
                level.m_5594_(null, mob.m_20183_(), SoundEvents.f_11921_, SoundSource.HOSTILE, 1.0f, 1.0f);
                mob.m_6703_(mob.m_21188_());
            }
        }
        if (affectMonsters && monsterPossessionList.containsKey(mob.m_6095_())) {
            posMob = mob.m_21406_(monsterPossessionList.get(type), true);
            if (type.equals(EntityType.f_20458_) && mob.m_21525_()) {
                posMob.m_146870_();
            }
        }
    }

    public static void revertPossession(Mob posMob, boolean canConvert) {
        EntityType posMobType = posMob.m_6095_();
        EntityType<? extends Mob> type = reversionList.get(posMob.m_6095_());
        if (posMob.m_6084_() && reversionList.containsKey(posMobType) && (!ConfigHandler.shouldDoMobPossession() || ConfigHandler.shouldPreventPossession(type) || ConfigHandler.shouldRevertPossession(canConvert) && !ModSavedData.get(posMob.m_9236_().m_7654_()).isApocalypseMode())) {
            Mob mob = posMob.m_21406_(type, true);
            if (posMobType.equals(EntityInit.P_PIG.get())) {
                if (((PosPig)posMob).m_6254_()) {
                    ((Pig)posMob).m_5853_(null);
                }
            } else if (posMobType.equals(EntityInit.P_RABBIT.get())) {
                ((Rabbit)mob).m_28464_(((PosRabbit)posMob).m_28554_());
            } else if (posMobType.equals(EntityInit.P_SHEEP.get())) {
                ((Sheep)mob).m_29855_(((PosSheep)posMob).m_29874_());
                ((Sheep)mob).m_29878_(((PosSheep)posMob).m_29875_());
            } else if (posMobType.equals(EntityInit.P_VILlAGER.get())) {
                ((Villager)mob).m_34375_(((PosVillager)posMob).m_7141_());
                ((Villager)mob).m_35476_(((PosVillager)posMob).m_6616_());
                ((Villager)mob).m_35546_(((PosVillager)posMob).m_7809_());
            } else if (posMobType.equals(EntityInit.P_ZOMBIE_VILLAGER.get())) {
                ((ZombieVillager)mob).m_34375_(((PosZombieVillager)posMob).m_7141_());
                ((ZombieVillager)mob).m_34411_(((PosZombieVillager)posMob).f_34362_);
            }
        }
    }

    public static boolean herobrineExists(Level level) {
        ArrayList list = new ArrayList();
        for (ServerPlayer serverplayer : level.m_7654_().m_6846_().m_11314_()) {
            list.addAll(level.m_45976_(AbstractHerobrine.class, serverplayer.m_20191_().m_82400_(256.0)));
        }
        return !list.isEmpty();
    }
}

