/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.possessed.animal;

import com.lgow.endofherobrine.entity.EntityInit;
import com.lgow.endofherobrine.entity.ModMobTypes;
import com.lgow.endofherobrine.entity.PossessedAnimal;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PosSheep
extends Sheep
implements NeutralMob,
PossessedAnimal {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)40, (int)80);
    private static final EntityDataAccessor<Integer> CLONE_NUMBER = SynchedEntityData.m_135353_(PosSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private int possessionTimer;

    public PosSheep(EntityType<? extends PosSheep> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public int getCloneNumber() {
        return (Integer)this.f_19804_.m_135370_(CLONE_NUMBER);
    }

    public void setCloneNumber(int num) {
        this.f_19804_.m_135381_(CLONE_NUMBER, (Object)num);
    }

    protected void m_8099_() {
        this.registerPosAnimalGoals((PathfinderMob)this, 1.25);
    }

    protected void m_8024_() {
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            ++this.possessionTimer;
            if (this.getCloneNumber() > 0 && this.f_19797_ > 2400 / this.getCloneNumber() + this.f_19796_.m_188503_(200)) {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_146870_();
            }
        }
    }

    @Override
    public boolean canRevertPossession() {
        return this.getCloneNumber() == 0 && PossessedAnimal.super.canRevertPossession();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CLONE_NUMBER, (Object)0);
    }

    public ResourceLocation m_7582_() {
        return new ResourceLocation("entities/sheep");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("CloneNumber", this.getCloneNumber());
        this.m_21678_(tag);
        this.addPossessionSavedData(tag, this.possessionTimer);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCloneNumber(tag.m_128451_("CloneNumber"));
        this.m_147285_(this.m_9236_(), tag);
        this.readPossessionSaveData(tag);
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    public Sheep m_142606_(ServerLevel server, AgeableMob mob) {
        return (Sheep)((EntityType)EntityInit.P_SHEEP.get()).m_20615_((Level)server);
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        this.m_6703_((LivingEntity)player);
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        return super.onSheared(player, item, level, pos, fortune);
    }

    public boolean m_6149_() {
        return super.m_6149_() && this.getCloneNumber() == 0;
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.getCloneNumber() == 0;
    }

    public void m_6668_(DamageSource source) {
        if (this.getCloneNumber() <= 3 && (source.m_7639_() instanceof Player || this.f_20888_ != null)) {
            for (int i = 0; i < 2; ++i) {
                this.createSheep();
            }
        }
        super.m_6668_(source);
    }

    public boolean m_6220_() {
        return this.getCloneNumber() == 0 && super.m_6220_();
    }

    public MobType m_6336_() {
        return ModMobTypes.POSSESSED;
    }

    private void createSheep() {
        PosSheep sheep = (PosSheep)((EntityType)EntityInit.P_SHEEP.get()).m_20615_(this.m_9236_());
        sheep.m_29855_(this.m_29874_());
        sheep.m_29878_(this.m_29875_());
        sheep.m_6863_(this.m_6162_());
        sheep.m_6593_(this.m_7770_());
        sheep.m_20359_((Entity)this);
        sheep.setCloneNumber(this.getCloneNumber() + 1);
        this.m_9236_().m_7967_((Entity)sheep);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    public void setPossessionTimer(int possessionTimer) {
        this.possessionTimer = possessionTimer;
    }

    @Override
    public int getPossessionTimer() {
        return this.possessionTimer;
    }
}

