/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.possessed.animal;

import com.lgow.endofherobrine.entity.EntityInit;
import com.lgow.endofherobrine.entity.ModMobTypes;
import com.lgow.endofherobrine.entity.PossessedAnimal;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PosRabbit
extends Rabbit
implements NeutralMob,
PossessedAnimal {
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)40, (int)80);
    @Nullable
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    private int possessionTimer;

    public PosRabbit(EntityType<? extends PosRabbit> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22281_, 0.5);
    }

    protected ResourceLocation m_7582_() {
        return new ResourceLocation("entities/rabbit");
    }

    protected void m_8099_() {
        this.registerPosAnimalGoals((PathfinderMob)this, 2.2);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            ++this.possessionTimer;
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
        this.addPossessionSavedData(pCompound, this.possessionTimer);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
        this.readPossessionSaveData(pCompound);
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    public Rabbit m_142606_(ServerLevel server, AgeableMob mob) {
        return (Rabbit)((EntityType)EntityInit.P_RABBIT.get()).m_20615_((Level)server);
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloud);
        }
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.MOB);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    public void m_6668_(DamageSource source) {
        super.m_6668_(source);
        if (source.m_7639_() instanceof Player || this.f_20888_ != null) {
            this.explode();
        }
    }

    public MobType m_6336_() {
        return ModMobTypes.POSSESSED;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    public void setPossessionTimer(int possessionTimer) {
        this.possessionTimer = possessionTimer;
    }

    @Override
    public int getPossessionTimer() {
        return this.possessionTimer;
    }
}

