/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.herobrine;

import com.lgow.endofherobrine.block.BlockInit;
import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.entity.herobrine.AbstractHerobrine;
import com.lgow.endofherobrine.util.ModResourceLocation;
import com.lgow.endofherobrine.world.data.ModSavedData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Builder
extends AbstractHerobrine {
    private final String[] TRAPS = new String[]{"lantern"};
    private final String string = "herobrine";
    private final String directory = ConfigHandler.shouldBuildLegacyStructures() ? "legacy/" : "";
    private int buildTimer;

    public Builder(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean checkSafePos(LivingEntity entity, BlockPos.MutableBlockPos mutablePos, boolean avoidwater) {
        return mutablePos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutablePos).m_280555_() || this.m_9236_().m_8055_((BlockPos)mutablePos).m_204336_(BlockTags.f_13035_);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!this.canSeeAnyPlayers()) {
            this.tpToWatchPlayer(this.getNearestPlayer());
        }
        this.teleportCooldown = 5;
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void placeStructure(String resLoc, int yOffset) {
        Level level = this.m_20193_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            boolean canBuild = true;
            BlockPos pos = this.m_20183_().m_7918_(0, yOffset, 0);
            StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)this.f_19796_)).m_74377_(Mirror.NONE);
            StructureTemplate structure = server.m_215082_().m_230359_((ResourceLocation)new ModResourceLocation(this.directory + resLoc));
            for (BlockState state : server.m_45556_(AABB.m_82321_((BoundingBox)structure.m_74633_(settings, pos))).toList()) {
                if (!state.m_204343_().toList().contains(BlockInit.NO_OVERRIDE)) continue;
                canBuild = false;
            }
            if (!canBuild) {
                this.tpToWatchPlayer(this.getNearestPlayer());
                this.buildTimer = 0;
            } else {
                structure.m_230328_((ServerLevelAccessor)server, pos, pos, settings, this.f_19796_, 2);
                this.m_146870_();
            }
        }
    }

    private String getLetterToBuild(int lastLetterIndex) {
        return this.m_7755_().getString().toLowerCase().substring(lastLetterIndex, lastLetterIndex + 1);
    }

    private void selectStructure(String[] structures, int yOffset) {
        int rand = this.f_19796_.m_188503_(structures.length);
        this.placeStructure(structures[rand], yOffset);
    }

    private void build() {
        if (this.canSeeAnyPlayers() && this.getNearestPlayer() != null) {
            if (this.m_9236_().m_45527_(this.m_20183_()) && this.m_20270_((Entity)this.getNearestPlayer()) >= 10.0f) {
                if (this.f_19796_.m_188503_(5) != 0) {
                    this.placeStructure(this.getLetterToBuild(ModSavedData.get(this.m_20194_()).getLastLetterIndex()), 0);
                    ModSavedData.get(this.m_20194_()).updateLastLetterIndex();
                } else {
                    this.selectStructure(this.TRAPS, -1);
                }
            } else {
                this.buildSign();
            }
        }
    }

    private void buildSign() {
        BuilderMessage signText = BuilderMessage.getRandomText(this.f_19796_);
        BlockPos pos = this.m_20183_();
        this.m_9236_().m_46597_(pos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(Mth.m_14143_((float)this.m_146909_()) & 0xF)));
        this.m_9236_().m_245803_((Entity)this, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.5f, (float)((double)0.8f + Math.random() * 0.2));
        SignBlockEntity existingBlockEntity = (SignBlockEntity)this.m_9236_().getExistingBlockEntity(pos);
        SignText text = new SignText();
        for (int line : signText.lines) {
            text = text.m_276913_(line, (Component)Component.m_237115_((String)("sign." + signText.prefix + line)));
        }
        existingBlockEntity.m_276956_(text, true);
        existingBlockEntity.m_276956_(text, false);
        this.m_146870_();
    }

    @Override
    public void m_8024_() {
        if (++this.buildTimer >= 100) {
            this.build();
        }
        super.m_8024_();
    }

    private static enum BuilderMessage {
        LEAVE("leave", 1, 2),
        STOP("stop", 1),
        WATCHING("watching", 1),
        WELCOME("welcome", 1, 2);

        private static final List<BuilderMessage> VALUES;
        private final String prefix;
        private final int[] lines;

        private BuilderMessage(String name, int ... lines) {
            this.prefix = name;
            this.lines = lines;
        }

        private static BuilderMessage getRandomText(RandomSource random) {
            return VALUES.get(random.m_188503_(VALUES.size()));
        }

        static {
            VALUES = List.of(BuilderMessage.values());
        }
    }
}

