/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.entity.herobrine;

import com.lgow.endofherobrine.entity.ModMobTypes;
import com.lgow.endofherobrine.entity.Teleporter;
import com.lgow.endofherobrine.entity.ai.StarePlayerGoal;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHerobrine
extends PathfinderMob
implements Teleporter {
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.m_135353_(AbstractHerobrine.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected int teleportCooldown;
    @Nullable
    private Player targetPlayer;
    private boolean shouldFoat;

    protected AbstractHerobrine(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 0;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 256.0).m_22268_(Attributes.f_22281_, 0.1);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.spawnPositoning(this.m_20183_());
        this.m_6593_((Component)Component.m_237113_((String)"Herobrine"));
        LogUtils.getLogger().info(this.m_6095_().m_147048_().toUpperCase() + " spawned at " + this.m_20097_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new StarePlayerGoal((Mob)this, Float.MAX_VALUE, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PLAYER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.hasPlayerUUID()) {
            tag.m_128362_("PlayerUUID", this.getPlayerUUID());
        }
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128403_("PlayerUUID")) {
            uuid = tag.m_128342_("PlayerUUID");
        } else {
            String s = tag.m_128461_("PlayerUUID");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setPlayerUUID(uuid);
        }
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6673_(DamageSource pSource) {
        return !pSource.m_276093_(DamageTypes.f_286973_);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public MobType m_6336_() {
        return ModMobTypes.HEROBRINE;
    }

    public boolean m_6094_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions dim) {
        return 1.725f;
    }

    public InteractionResult m_21499_(Player pPlayer, InteractionHand pHand) {
        return InteractionResult.PASS;
    }

    @Nullable
    public Player getTargetPlayer() {
        return this.targetPlayer;
    }

    public void setTargetPlayer(@Nullable Player pTarget) {
        this.targetPlayer = pTarget;
    }

    public boolean m_142582_(Entity pEntity) {
        if (pEntity.m_9236_() != this.m_9236_()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(pEntity.m_20185_(), pEntity.m_20188_(), pEntity.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public int m_8085_() {
        return Integer.MAX_VALUE;
    }

    public int m_8132_() {
        return Integer.MAX_VALUE;
    }

    protected void m_8024_() {
        if (this.m_20069_()) {
            this.m_20219_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
            this.shouldFoat = true;
        }
        if (this.shouldFoat) {
            this.m_20256_(Vec3.f_82478_);
        }
        super.m_8024_();
    }

    public boolean hasPlayerUUID() {
        return this.getPlayerUUID() != null;
    }

    public UUID getPlayerUUID() {
        return ((Optional)this.f_19804_.m_135370_(PLAYER_UUID)).orElse(null);
    }

    public void setPlayerUUID(UUID uuid) {
        this.f_19804_.m_135381_(PLAYER_UUID, Optional.ofNullable(uuid));
    }

    public Player getPlayerByUUID() {
        return this.m_9236_().m_46003_(this.getPlayerUUID());
    }

    public boolean canSeeAnyPlayers() {
        if (this.m_9236_().f_46443_) {
            return false;
        }
        for (Player player : this.m_20194_().m_6846_().m_11314_()) {
            if (!this.m_142582_((Entity)player)) continue;
            this.setTargetPlayer(player);
            return true;
        }
        return false;
    }

    public void destroyBlocksInAABB(AABB area) {
        int minX = Mth.m_14107_((double)area.f_82288_);
        int minY = Mth.m_14107_((double)area.f_82289_);
        int minZ = Mth.m_14107_((double)area.f_82290_);
        int maxX = Mth.m_14107_((double)area.f_82291_);
        int maxY = Mth.m_14107_((double)area.f_82292_);
        int maxZ = Mth.m_14107_((double)area.f_82293_);
        boolean destroyBlock = false;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos blockpos = new BlockPos(x, y, z);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_13076_)) continue;
                    destroyBlock = this.m_9236_().m_46961_(blockpos, true);
                }
            }
        }
        if (destroyBlock) {
            this.m_21011_(InteractionHand.MAIN_HAND, true);
        }
    }

    protected boolean tpToWatchPlayer(Player player) {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && player != null) {
            double randX = this.f_19796_.m_216332_(15, 40);
            double randZ = this.f_19796_.m_216332_(15, 40);
            double x = player.m_20185_() + (this.f_19796_.m_188499_() ? randX : -randX);
            double y = player.m_20186_() + (double)this.f_19796_.m_188503_(16);
            double z = player.m_20189_() + (this.f_19796_.m_188499_() ? randZ : -randZ);
            return this.attemptTeleport((LivingEntity)this, x, y, z, (LivingEntity)player, !this.m_9236_().m_204166_(player.m_20183_()).m_203656_(BiomeTags.f_207603_));
        }
        return false;
    }

    public void spawnPositoning(BlockPos pos) {
        BlockState blockState = this.m_9236_().m_8055_(pos.m_7494_());
        boolean blocksMotion = blockState.m_280555_();
        if (blocksMotion && this.m_9236_().m_45527_(pos.m_7494_())) {
            this.m_20035_(pos.m_7494_(), this.m_146909_(), this.m_146908_());
        } else if (this.m_5830_()) {
            this.destroyBlocksInAABB(this.m_20191_());
        }
    }

    protected void teleportAway() {
        this.m_9236_().m_7605_((Entity)this, (byte)46);
        if (!this.m_20067_()) {
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        this.m_146870_();
    }

    public Player getNearestPlayer() {
        return this.m_9236_().m_45946_(TargetingConditions.m_148353_().m_148355_(), (LivingEntity)this);
    }
}

