/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.config;

import java.util.Objects;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final Server SERVER;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static boolean enabledExperimentalFeatures() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.EXPERIMENTAL_FEATURES) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.EXPERIMENTAL_FEATURES)) {
            return (Boolean)Common.EXPERIMENTAL_FEATURES.get();
        }
        return (Boolean)Server.EXPERIMENTAL_FEATURES.get();
    }

    public static boolean isValueDefault(ForgeConfigSpec.ConfigValue spec) {
        return Objects.equals(spec.get(), spec.getDefault());
    }

    public static int getRemainPossessedTicks() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.REMAIN_POSSESSED_TICKS) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.REMAIN_POSSESSED_TICKS)) {
            return (Integer)Common.REMAIN_POSSESSED_TICKS.get();
        }
        return (Integer)Server.REMAIN_POSSESSED_TICKS.get();
    }

    public static int getSpawnCooldown() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.SPAWN_COOLDOWN) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.SPAWN_COOLDOWN)) {
            return (Integer)Common.SPAWN_COOLDOWN.get();
        }
        return (Integer)Server.SPAWN_COOLDOWN.get();
    }

    public static int getSpawnChance() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.SPAWN_CHANCE) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.SPAWN_CHANCE)) {
            return (Integer)Common.SPAWN_CHANCE.get();
        }
        return (Integer)Server.SPAWN_CHANCE.get();
    }

    public static boolean shouldBuildLegacyStructures() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.LEGACY_STRUCTURES) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.LEGACY_STRUCTURES)) {
            return (Boolean)Common.LEGACY_STRUCTURES.get();
        }
        return (Boolean)Server.LEGACY_STRUCTURES.get();
    }

    public static boolean isWrathProgressive() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.PROGRESSIVE_WRATH) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.PROGRESSIVE_WRATH)) {
            return (Boolean)Common.PROGRESSIVE_WRATH.get();
        }
        return (Boolean)Server.PROGRESSIVE_WRATH.get();
    }

    public static boolean shouldDoMobPossession() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.MOB_POSSESSION) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.MOB_POSSESSION)) {
            return (Boolean)Common.MOB_POSSESSION.get();
        }
        return (Boolean)Server.MOB_POSSESSION.get();
    }

    public static boolean shouldPreventPossession(EntityType<?> entity) {
        if (!entity.m_20675_().startsWith("entity.minecraft.")) {
            return true;
        }
        if (ConfigHandler.isValueDefault(Server.BLACKLIST_POSSESSION) && !ConfigHandler.isValueDefault(Common.BLACKLIST_POSSESSION)) {
            return ((String)Common.BLACKLIST_POSSESSION.get()).contains(entity.m_20675_().replace("entity.minecraft.", ""));
        }
        return ((String)Server.BLACKLIST_POSSESSION.get()).contains(entity.m_20675_().replace("entity.minecraft.", ""));
    }

    public static boolean shouldRevertPossession(boolean canConvert) {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.REVERT_POSSESSION) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.REVERT_POSSESSION)) {
            return (Boolean)Common.REVERT_POSSESSION.get() != false && canConvert;
        }
        return (Boolean)Server.REVERT_POSSESSION.get() != false && canConvert;
    }

    public static boolean shouldSpawnBuilder() {
        if (ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Server.SPAWN_BUILDER) && !ConfigHandler.isValueDefault((ForgeConfigSpec.ConfigValue)Common.SPAWN_BUILDER)) {
            return (Boolean)Common.SPAWN_BUILDER.get();
        }
        return (Boolean)Server.SPAWN_BUILDER.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        protected static ForgeConfigSpec.IntValue REMAIN_POSSESSED_TICKS;
        protected static ForgeConfigSpec.IntValue SPAWN_COOLDOWN;
        protected static ForgeConfigSpec.IntValue SPAWN_CHANCE;
        protected static ForgeConfigSpec.BooleanValue EXPERIMENTAL_FEATURES;
        protected static ForgeConfigSpec.BooleanValue LEGACY_STRUCTURES;
        protected static ForgeConfigSpec.BooleanValue MOB_POSSESSION;
        protected static ForgeConfigSpec.BooleanValue PROGRESSIVE_WRATH;
        protected static ForgeConfigSpec.BooleanValue REVERT_POSSESSION;
        protected static ForgeConfigSpec.BooleanValue SPAWN_BUILDER;
        protected static ForgeConfigSpec.ConfigValue<String> BLACKLIST_POSSESSION;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Common configs for The End of Herobrine Mod");
            EXPERIMENTAL_FEATURES = builder.comment("Should enable experimental features?").define("experimental", false);
            LEGACY_STRUCTURES = builder.comment("Should Herobrine build 1.7.10 structures?").define("legacyStructures", false);
            PROGRESSIVE_WRATH = builder.comment("Should Herobrine's Wrath progressively raise during gameplay?").define("progressiveWrath", true);
            builder.comment("\n## Possession ###\n");
            MOB_POSSESSION = builder.comment("Should mobs get possessed?").define("mobPossession", true);
            REVERT_POSSESSION = builder.comment("Should possessed animals revert to normal?").define("revertPossession", true);
            REMAIN_POSSESSED_TICKS = builder.comment("Time in ticks mobs will remain possessed  #Default: 1/2 minecraft day").defineInRange("remainPossessedTicks", 12000, 0, Integer.MAX_VALUE);
            BLACKLIST_POSSESSION = builder.comment("List of mobs that should not get possessed #Example: \"husk, pig, villager\"").define("blacklistPossession", (Object)"");
            builder.comment("\n## Herobrine Spawn###\n");
            SPAWN_COOLDOWN = builder.comment("Time in ticks between Herobrine spawn attempts").defineInRange("spawnCooldown", 3600, 0, Integer.MAX_VALUE);
            SPAWN_CHANCE = builder.comment("Chance of a herobrine spawn attempt being successful").defineInRange("spawnChance", 10, 0, 100);
            SPAWN_BUILDER = builder.comment("Should spawn herobrine builder?").define("spawnBuilder", true);
            builder.pop();
        }

        public static void setRemainPossessedTicks(int value) {
            REMAIN_POSSESSED_TICKS.set((Object)value);
        }

        public static void setSpawnCooldown(int value) {
            SPAWN_COOLDOWN.set((Object)value);
        }

        public static void setSpawnChance(int value) {
            SPAWN_CHANCE.set((Object)value);
        }

        public static void setStructures(boolean value) {
            LEGACY_STRUCTURES.set((Object)value);
        }

        public static void setMobPossession(boolean value) {
            MOB_POSSESSION.set((Object)value);
        }

        public static void setRevertPossession(boolean value) {
            REVERT_POSSESSION.set((Object)value);
        }

        public static void setSpawnBuilder(boolean value) {
            SPAWN_BUILDER.set((Object)value);
        }

        public static void setProgressiveWrath(boolean value) {
            PROGRESSIVE_WRATH.set((Object)value);
        }

        public static void setExperimentalFeatures(boolean value) {
            EXPERIMENTAL_FEATURES.set((Object)value);
        }
    }

    public static class Common {
        protected static ForgeConfigSpec.IntValue REMAIN_POSSESSED_TICKS;
        protected static ForgeConfigSpec.IntValue SPAWN_COOLDOWN;
        protected static ForgeConfigSpec.IntValue SPAWN_CHANCE;
        protected static ForgeConfigSpec.BooleanValue EXPERIMENTAL_FEATURES;
        protected static ForgeConfigSpec.BooleanValue LEGACY_STRUCTURES;
        protected static ForgeConfigSpec.BooleanValue MOB_POSSESSION;
        protected static ForgeConfigSpec.BooleanValue PROGRESSIVE_WRATH;
        protected static ForgeConfigSpec.BooleanValue REVERT_POSSESSION;
        protected static ForgeConfigSpec.BooleanValue SPAWN_BUILDER;
        protected static ForgeConfigSpec.ConfigValue<String> BLACKLIST_POSSESSION;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("Common configs for The End of Herobrine Mod");
            EXPERIMENTAL_FEATURES = builder.comment("Should enable experimental features?").define("experimental", false);
            LEGACY_STRUCTURES = builder.comment("Should Herobrine build 1.7.10 structures?").define("legacyStructures", false);
            PROGRESSIVE_WRATH = builder.comment("Should Herobrine's Wrath raise during gameplay?").define("progressiveWrath", true);
            builder.comment("\n## Possession ###\n");
            MOB_POSSESSION = builder.comment("Should mobs get possessed?").define("mobPossession", true);
            REVERT_POSSESSION = builder.comment("Should possessed animals revert to normal?").define("revertPossession", true);
            REMAIN_POSSESSED_TICKS = builder.comment("Time in ticks mobs will remain possessed  #Default: 1/2 minecraft day").defineInRange("remainPossessedTicks", 12000, 0, Integer.MAX_VALUE);
            BLACKLIST_POSSESSION = builder.comment("List of mobs that should not get possessed #Example: \"husk, pig, villager\"").define("blacklistPossession", (Object)"");
            builder.comment("\n## Herobrine Spawn###\n");
            SPAWN_COOLDOWN = builder.comment("Time in ticks between Herobrine spawn attempts").defineInRange("spawnCooldown", 3600, 0, Integer.MAX_VALUE);
            SPAWN_CHANCE = builder.comment("Chance of a herobrine spawn attempt being successful").defineInRange("spawnChance", 10, 0, 100);
            SPAWN_BUILDER = builder.comment("Should spawn herobrine builder?").define("spawnBuilder", true);
            builder.pop();
        }
    }
}

