/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.commands;

import com.lgow.endofherobrine.capability.CapabilityProvider;
import com.lgow.endofherobrine.config.ConfigHandler;
import com.lgow.endofherobrine.world.data.ModSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EndOfHerobrineCommand {
    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"endofherobrine").requires(r -> r.m_6761_(3))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"data").then(Commands.m_82127_((String)"herobrineRestTimer").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(r -> EndOfHerobrineCommand.setHerobrineRestTimer((CommandSourceStack)r.getSource(), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"hasDefeatedHerobrine").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setHasDefeatedHerobrine((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"apocalypseMode").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setApocalypseMode((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"herobrineIsDead").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setHerobrineIsDead((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value"))))))).then(Commands.m_82127_((String)"help").executes(r -> EndOfHerobrineCommand.runHelp((CommandSourceStack)r.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wrath").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(r -> EndOfHerobrineCommand.wrathSet((CommandSourceStack)r.getSource(), Collections.singleton(((CommandSourceStack)r.getSource()).m_81375_()), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(r -> EndOfHerobrineCommand.wrathAdd((CommandSourceStack)r.getSource(), Collections.singleton(((CommandSourceStack)r.getSource()).m_81375_()), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"sub").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(r -> EndOfHerobrineCommand.wrathSub((CommandSourceStack)r.getSource(), Collections.singleton(((CommandSourceStack)r.getSource()).m_81375_()), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"reset").executes(r -> EndOfHerobrineCommand.wrathReset((CommandSourceStack)r.getSource(), ((CommandSourceStack)r.getSource()).m_81372_()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"serverConfig").then(Commands.m_82127_((String)"experimentalFeatures").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setExperimentalFeatures((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"legacyStructures").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setLegacyStructures((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"mobPossession").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setMobPossession((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"progressiveWrath").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setProgressiveWrath((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"revertPossession").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setRevertPossession((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"remainPossessedTicks").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(r -> EndOfHerobrineCommand.setRemainPossessedTicks((CommandSourceStack)r.getSource(), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"spawnCooldown").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(r -> EndOfHerobrineCommand.setSpawnCooldown((CommandSourceStack)r.getSource(), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"spawnChance").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(r -> EndOfHerobrineCommand.setSpawnChance((CommandSourceStack)r.getSource(), IntegerArgumentType.getInteger((CommandContext)r, (String)"value")))))).then(Commands.m_82127_((String)"spawnBuilder").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(r -> EndOfHerobrineCommand.setSpawnBuilder((CommandSourceStack)r.getSource(), BoolArgumentType.getBool((CommandContext)r, (String)"value")))))));
    }

    private static int setExperimentalFeatures(CommandSourceStack source, boolean value) {
        ConfigHandler.Server.setExperimentalFeatures(value);
        source.m_288197_(() -> Component.m_237113_((String)("ExperimentalFeatures set to " + value)), true);
        return 1;
    }

    private static int setHerobrineIsDead(CommandSourceStack source, boolean value) {
        ModSavedData.get(source.m_81377_()).setHerobrineIsDead(value);
        source.m_288197_(() -> Component.m_237113_((String)("HerobrineIsDead set to " + value)), true);
        return 1;
    }

    private static int setApocalypseMode(CommandSourceStack source, boolean value) {
        ModSavedData.get(source.m_81377_()).setApocalypseMode(value);
        source.m_288197_(() -> Component.m_237113_((String)("ApocalypseMode set to " + value)), true);
        return 1;
    }

    private static int setHasDefeatedHerobrine(CommandSourceStack source, boolean value) {
        ModSavedData.get(source.m_81377_()).setHasDefeatedHerobrine(value);
        source.m_288197_(() -> Component.m_237113_((String)("HasDefeatedHerobrine set to " + value)), true);
        return 1;
    }

    private static int setHerobrineRestTimer(CommandSourceStack source, int value) {
        ModSavedData.get(source.m_81377_()).setHerobrineRestTimer(value);
        source.m_288197_(() -> Component.m_237113_((String)("HerobrineRestTimer set to " + value)), true);
        return 1;
    }

    public static int wrathReset(CommandSourceStack pSource, ServerLevel server) {
        for (ServerPlayer serverPlayer : server.m_7654_().m_6846_().m_11314_()) {
            serverPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(pRaivinhaUiui -> {
                pRaivinhaUiui.setValue(0, serverPlayer);
                pSource.m_288197_(() -> Component.m_237113_((String)"Wrath reset"), true);
            });
        }
        return 1;
    }

    public static int wrathSet(CommandSourceStack pSource, Collection<? extends Player> pTargets, int value) {
        for (Player player : pTargets) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(pRaivinhaUiui -> {
                pRaivinhaUiui.setValue(value, serverPlayer);
                pSource.m_288197_(() -> Component.m_237113_((String)("Wrath set to " + value)), true);
            });
        }
        return 1;
    }

    public static int wrathAdd(CommandSourceStack pSource, Collection<? extends Player> pTargets, int value) {
        for (Player player : pTargets) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(pRaivinhaUiui -> {
                pRaivinhaUiui.addValue(value, serverPlayer);
                pSource.m_288197_(() -> Component.m_237113_((String)("Wrath added " + value)), true);
            });
        }
        return 1;
    }

    public static int wrathSub(CommandSourceStack pSource, Collection<? extends Player> pTargets, int value) {
        for (Player player : pTargets) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CapabilityProvider.WRATH).ifPresent(pRaivinhaUiui -> {
                pRaivinhaUiui.subValue(value, serverPlayer);
                pSource.m_288197_(() -> Component.m_237113_((String)("Wrath subtracted " + value)), true);
            });
        }
        return 1;
    }

    public static int setProgressiveWrath(CommandSourceStack pSource, boolean value) {
        ConfigHandler.Server.setProgressiveWrath(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("progressiveWrath set to " + value)), true);
        return 1;
    }

    public static int setLegacyStructures(CommandSourceStack pSource, boolean value) {
        ConfigHandler.Server.setStructures(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("legacySctructures set to " + value)), true);
        return 1;
    }

    public static int setRemainPossessedTicks(CommandSourceStack pSource, int value) {
        ConfigHandler.Server.setRemainPossessedTicks(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("remainPossessedTicks set to " + value)), true);
        return 1;
    }

    public static int setMobPossession(CommandSourceStack pSource, boolean value) {
        ConfigHandler.Server.setMobPossession(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("mobPossession set to " + value)), true);
        return 1;
    }

    public static int setSpawnBuilder(CommandSourceStack pSource, boolean value) {
        ConfigHandler.Server.setSpawnBuilder(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("spawnBuilder set to " + value)), true);
        return 1;
    }

    public static int setSpawnChance(CommandSourceStack pSource, int value) {
        ConfigHandler.Server.setSpawnChance(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("spawnChance set to " + value)), true);
        return 1;
    }

    public static int setRevertPossession(CommandSourceStack pSource, boolean value) {
        ConfigHandler.Server.setRevertPossession(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("revertPossession set to " + value)), true);
        return 1;
    }

    public static int setSpawnCooldown(CommandSourceStack pSource, int value) {
        ConfigHandler.Server.setSpawnCooldown(value);
        pSource.m_288197_(() -> Component.m_237113_((String)("spawnCooldown set to " + value)), true);
        return 1;
    }

    public static int runHelp(CommandSourceStack pSource) {
        pSource.m_288197_(() -> EndOfHerobrineCommand.command("data", "Allows you to manually set data values", true).m_6881_().m_7220_(EndOfHerobrineCommand.command("apocalypseMode", "If true all events will be extremely", "    common \u00a7c(FEATURE_NOT_FINAL)", false)).m_7220_(EndOfHerobrineCommand.command("hasDefeatedHerobrine", "If true increases Herobrine's", "            aggressiveness \u00a7c(NOT_FINAL)", false)).m_7220_(EndOfHerobrineCommand.command("herobrineIsDead", "If true all mod features are disabled", false)).m_7220_(EndOfHerobrineCommand.command("herobrineRestTimer", "Amount of ticks Herobrine should", "        be inactive for", false)).m_130946_("\n").m_7220_(EndOfHerobrineCommand.command("serverConfig", "Allows you to edit server configs while in game", true)).m_7220_(EndOfHerobrineCommand.command("legacyStructures", "If true Builder builds retro style", "      structures", false)).m_7220_(EndOfHerobrineCommand.command("mobPossession", "If true mobs get possessed", false)).m_7220_(EndOfHerobrineCommand.command("progressiveWrath", "If true Herobrine's wrath will", "      progressively increase", false)).m_7220_(EndOfHerobrineCommand.command("remainPossessedTicks", "Amount of ticks mobs should", "           remain possessed", false)).m_7220_(EndOfHerobrineCommand.command("revertPossession", "If true possessed mobs revert to", "      normal after some time", false)).m_7220_(EndOfHerobrineCommand.command("spawnBuilder", "If true Builder Herobrine variant spawns", false)).m_7220_(EndOfHerobrineCommand.command("spawnChance", "Chance of a Herobrine spawn attempt", "being successful", false)).m_7220_(EndOfHerobrineCommand.command("spawnCooldown", "Amount of ticks between Herobrine", "  spawn attempts", false)).m_130946_("\n").m_7220_(EndOfHerobrineCommand.command("wrath", "Allows you to customize Herobrine's wrath", true)).m_7220_(EndOfHerobrineCommand.command("add", "Increases wrath by the given value", false)).m_7220_(EndOfHerobrineCommand.command("set", "Sets wrath by the given value value", false)).m_7220_(EndOfHerobrineCommand.command("sub", "Decreases wrath by the given value", false)).m_7220_(EndOfHerobrineCommand.command("reset", "Resets Herobrine's wrath for all players", false)), true);
        return 1;
    }

    private static Component command(String name, String description, boolean isPrimary) {
        String spacement = isPrimary ? "" : "\n       ";
        String colorName = isPrimary ? "\u00a7b" : "\u00a7e";
        String colorDesc = isPrimary ? "\u00a7r" : "\u00a77";
        return Component.m_237113_((String)(spacement + colorName + name + colorDesc + " - " + description + "."));
    }

    private static Component command(String name, String description1, String description2, boolean isPrimary) {
        String spacement = isPrimary ? "" : "\n       ";
        String colorName = isPrimary ? "\u00a7b" : "\u00a7e";
        String colorDesc = isPrimary ? "\u00a7r" : "\u00a77";
        return Component.m_237113_((String)(spacement + colorName + name + colorDesc + " - " + description1 + "\n                           " + description2 + "."));
    }
}

