/*
 * Decompiled with CFR 0.152.
 */
package com.lgow.endofherobrine.block;

import com.lgow.endofherobrine.block.ArmorStandBaseBlock;
import com.lgow.endofherobrine.block.GlowingObsidianBlock;
import com.lgow.endofherobrine.block.ModInfestedBlock;
import com.lgow.endofherobrine.block.ModSkullBlock;
import com.lgow.endofherobrine.block.ModWallSkullBlock;
import com.lgow.endofherobrine.block.TotemBlock;
import com.lgow.endofherobrine.registries.ModRegistries;
import com.lgow.endofherobrine.util.ModResourceLocation;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final RegistryObject<Block> CURSED_SKULL;
    public static final RegistryObject<Block> HEROBRINE_SKULL;
    public static final RegistryObject<Block> CURSED_WALL_SKULL;
    public static final RegistryObject<Block> HEROBRINE_WALL_SKULL;
    public static final RegistryObject<Block> ARMOR_STAND_BASE;
    public static final RegistryObject<BlockItem> GLOWING_OBSIDIAN;
    public static final RegistryObject<BlockItem> NETHERRACK_TOTEM;
    public static final RegistryObject<BlockItem> BLACKSTONE_TOTEM;
    public static final RegistryObject<BlockItem> PATIMUSS_DOOR;
    public static final TagKey<Block> NO_OVERRIDE;

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier) {
        return ModRegistries.MOD_BLOCKS.register(name, blockSupplier);
    }

    private static RegistryObject<Block> registerSkullBlock(String name, ModSkullBlock.Types type) {
        return BlockInit.registerBlock(name, () -> new ModSkullBlock(type, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50316_)));
    }

    private static RegistryObject<Block> registerWallSkullBlock(String name, ModSkullBlock.Types type) {
        return BlockInit.registerBlock(name, () -> new ModWallSkullBlock(type, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50316_)));
    }

    private static void registerInfestedBlock(String name, Block blockIn) {
        BlockInit.registerBlock(name, () -> new ModInfestedBlock(blockIn, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50226_)));
    }

    private static <T extends Block> RegistryObject<BlockItem> registerBlockItem(String name, Supplier<T> blockSupplier) {
        RegistryObject block = BlockInit.registerBlock(name, blockSupplier);
        return ModRegistries.MOD_ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register() {
    }

    static {
        NO_OVERRIDE = BlockTags.create((ResourceLocation)new ModResourceLocation("prevent_builder_override"));
        CURSED_SKULL = BlockInit.registerSkullBlock("cursed_head", ModSkullBlock.Types.CURSED);
        HEROBRINE_SKULL = BlockInit.registerSkullBlock("herobrine_head", ModSkullBlock.Types.HEROBRINE);
        CURSED_WALL_SKULL = BlockInit.registerWallSkullBlock("cursed_wall_head", ModSkullBlock.Types.CURSED);
        HEROBRINE_WALL_SKULL = BlockInit.registerWallSkullBlock("herobrine_wall_head", ModSkullBlock.Types.HEROBRINE);
        GLOWING_OBSIDIAN = BlockInit.registerBlockItem("glowing_obsidian", GlowingObsidianBlock::new);
        NETHERRACK_TOTEM = BlockInit.registerBlockItem("netherrack_totem", () -> new TotemBlock(Blocks.f_50134_));
        BLACKSTONE_TOTEM = BlockInit.registerBlockItem("blackstone_totem", () -> new TotemBlock(Blocks.f_50730_));
        PATIMUSS_DOOR = BlockInit.registerBlockItem("patimuss_door", () -> new DoorBlock(BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.CYAN).m_60955_().m_278166_(PushReaction.DESTROY), BlockSetType.f_271198_));
        BlockInit.registerInfestedBlock("cracked_stone_bricks", Blocks.f_50224_);
        BlockInit.registerInfestedBlock("mossy_cobblestone", Blocks.f_50079_);
        BlockInit.registerInfestedBlock("mossy_stone_bricks", Blocks.f_50223_);
        BlockInit.registerBlock("glowstone", () -> new ModInfestedBlock(Blocks.f_50141_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50316_).m_60953_(blockState -> 15).m_60918_(SoundType.f_56744_)));
        ARMOR_STAND_BASE = BlockInit.registerBlock("armor_stand_base", () -> new ArmorStandBaseBlock(BlockBehaviour.Properties.m_284310_().m_60910_()));
    }
}

