/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure.prefabs;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.barion.dungeons_enhanced.world.structure.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structure.prefabs.utils.DEStructureTemplates;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DESwimmingStructure
extends DEBaseStructure {
    public static final String ID_FISHING_SHIP = "fishing_ship";
    public static final Codec<DESwimmingStructure> CODEC_FISHING_SHIP = DESwimmingStructure.m_226607_(DESwimmingStructure::FishingShip);

    public static DESwimmingStructure FishingShip(Structure.StructureSettings settings) {
        return new DESwimmingStructure(settings, DEUtil.pieceBuilder().yOffset(-3).add(ID_FISHING_SHIP).build(), () -> DEStructures.FISHING_SHIP.getType());
    }

    protected DESwimmingStructure(Structure.StructureSettings settings, DEStructureTemplates variants, Supplier<StructureType<?>> type) {
        super(settings, variants, type);
    }

    protected static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    @Override
    @Nonnull
    public Optional<Structure.GenerationStub> m_214086_(@Nonnull Structure.GenerationContext context) {
        DEStructureTemplates.Template template = this._templates.getRandom((RandomSource)context.f_226626_());
        BlockPos pos = this.getGenPos(context).m_6630_(template.yOffset);
        return DESwimmingStructure.at(pos, builder -> DESwimmingStructure.generatePieces(builder, pos, template, Rotation.m_221990_((RandomSource)context.f_226626_()), context, DESwimmingStructure::assemble));
    }

    protected BlockPos getGenPos(Structure.GenerationContext context) {
        return DEUtil.chunkPosToBlockPosFromHeightMap(context.f_226628_(), context.f_226622_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
    }

    public static class Piece
    extends DEBaseStructure.Piece {
        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super((Registrar.Static<StructurePieceType>)DEStructures.FISHING_SHIP.getPieceType(), structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super((Registrar.Static<StructurePieceType>)DEStructures.FISHING_SHIP.getPieceType(), serializationContext, nbt);
        }
    }
}

