/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.data.provider;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.registry.DEStructures;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.jetbrains.annotations.NotNull;

public final class DEAdvancementProvider
extends ForgeAdvancementProvider {
    public static final CompletableFuture<HolderLookup.Provider> registriesLookup = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());

    public DEAdvancementProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, registriesLookup, existingFileHelper, List.of(new DEExplorerAdvancementSubProvider()));
    }

    public static final class DEExplorerAdvancementSubProvider
    implements ForgeAdvancementProvider.AdvancementGenerator {
        public void generate(@Nonnull HolderLookup.Provider registries, @Nonnull Consumer<Advancement> consumer, @Nonnull ExistingFileHelper existingFileHelper) {
            Advancement root = new AdvancementBuilder("root", (ItemLike)Items.f_42522_).background("textures/block/mossy_cobblestone.png").hideToast().hideInChat().orCriterions().onEnterStructures(DEStructures.ALL_STRUCTURE_REGISTRARS).save(consumer, existingFileHelper);
            new AdvancementBuilder("hidden_under_the_roots", (ItemLike)Items.f_42055_).parent(root).onEnterStructure(DEStructures.MONSTER_MAZE).save(consumer, existingFileHelper);
            new AdvancementBuilder("thats_a_dungeon", (ItemLike)Items.f_42678_).parent(root).onEnterStructure(DEStructures.LARGE_DUNGEON).save(consumer, existingFileHelper);
            new AdvancementBuilder("traps_and_curses", (ItemLike)Items.f_41996_).parent(root).onEnterStructure(DEStructures.DESERT_TEMPLE).save(consumer, existingFileHelper);
            new AdvancementBuilder("ancient_civilizations", (ItemLike)Items.f_41911_).parent(root).onEnterStructure(DEStructures.JUNGLE_MONUMENT).save(consumer, existingFileHelper);
            new AdvancementBuilder("wars_and_kingdoms", (ItemLike)Items.f_42018_).parent(root).onEnterStructure(DEStructures.CASTLE).save(consumer, existingFileHelper);
            new AdvancementBuilder("rarest_structure", (ItemLike)Items.f_41953_).parent(root).onEnterStructure(DEStructures.MUSHROOM_HOUSE).save(consumer, existingFileHelper);
            new AdvancementBuilder("chilled_halls", (ItemLike)Items.f_42500_).parent(root).onEnterStructure(DEStructures.ICE_PIT).save(consumer, existingFileHelper);
            new AdvancementBuilder("ahoy", (ItemLike)Items.f_42679_).parent(root).onEnterStructure(DEStructures.PIRATE_SHIP).save(consumer, existingFileHelper);
            new AdvancementBuilder("in_the_air", (ItemLike)Items.f_42778_).parent(root).onEnterStructure(DEStructures.FLYING_DUTCHMAN).save(consumer, existingFileHelper);
            new AdvancementBuilder("sunken_deeps", (ItemLike)Items.f_42715_).parent(root).onEnterStructure(DEStructures.ELDERS_TEMPLE).save(consumer, existingFileHelper);
            new AdvancementBuilder("spooky_scary_citadel", new BannerBuilder(Items.f_42727_).addPattern((ResourceKey<BannerPattern>)BannerPatterns.f_222719_, DyeColor.BLACK).addPattern((ResourceKey<BannerPattern>)BannerPatterns.f_222718_, DyeColor.RED).addPattern((ResourceKey<BannerPattern>)BannerPatterns.f_222722_, DyeColor.BLACK).addPattern((ResourceKey<BannerPattern>)BannerPatterns.f_222715_, DyeColor.BLACK).build()).parent(root).onEnterStructure(DEStructures.BLACK_CITADEL).save(consumer, existingFileHelper);
            Advancement sevenWorldWonders = new AdvancementBuilder("seven_world_wonders", (ItemLike)Items.f_151059_).parent(root).type(FrameType.GOAL).onEnterStructures(DEStructures.CASTLE, DEStructures.DEEP_CRYPT, DEStructures.DESERT_TEMPLE, DEStructures.ICE_PIT, DEStructures.JUNGLE_MONUMENT, DEStructures.MONSTER_MAZE, DEStructures.ELDERS_TEMPLE).save(consumer, existingFileHelper);
            new AdvancementBuilder("ambitious_explorer", (ItemLike)Items.f_42573_).parent(sevenWorldWonders).type(FrameType.CHALLENGE).onEnterStructures(DEStructures.ALL_STRUCTURE_REGISTRARS).save(consumer, existingFileHelper);
        }
    }

    private static class BannerBuilder {
        private static final String PATTERNS = "Patterns";
        private static final String PATTERN = "Pattern";
        private static final String COLOR = "Color";
        private final ItemStack _bannerStack;
        private final CompoundTag _blockTag = new CompoundTag();
        private final ListTag _patternsTag = this._blockTag.m_128437_("Patterns", 10);

        public BannerBuilder(Item item) {
            this._bannerStack = item.m_7968_().m_41777_();
        }

        public BannerBuilder addPattern(ResourceKey<BannerPattern> pattern, DyeColor color) {
            CompoundTag patternTag = new CompoundTag();
            patternTag.m_128359_(PATTERN, Objects.requireNonNull((BannerPattern)BuiltInRegistries.f_256878_.m_6246_(pattern)).m_58579_());
            patternTag.m_128405_(COLOR, color.m_41060_());
            this._patternsTag.add((Object)patternTag);
            return this;
        }

        public ItemStack build() {
            this._blockTag.m_128365_(PATTERNS, (Tag)this._patternsTag);
            BlockItem.m_186338_((ItemStack)this._bannerStack, (BlockEntityType)BlockEntityType.f_58935_, (CompoundTag)this._blockTag);
            return this._bannerStack;
        }
    }

    private static class AdvancementBuilder {
        private final String _id;
        private final ItemStack _displayItem;
        private Advancement _parent = null;
        private ResourceLocation _background = null;
        private FrameType _type = FrameType.TASK;
        private boolean _showToast = true;
        private boolean _announceToChat = true;
        private boolean _hidden = false;
        private RequirementsStrategy _criterionStrategy = RequirementsStrategy.f_15978_;
        private final List<Pair<String, CriterionTriggerInstance>> _criterions = new ArrayList<Pair<String, CriterionTriggerInstance>>();

        private AdvancementBuilder(String id, ItemStack displayItem) {
            this._id = id;
            this._displayItem = displayItem;
        }

        private AdvancementBuilder(String id, ItemLike displayItem) {
            this(id, displayItem.m_5456_().m_7968_());
        }

        private AdvancementBuilder parent(Advancement parent) {
            this._parent = parent;
            return this;
        }

        public AdvancementBuilder background(String background) {
            return this.background(new ResourceLocation(background));
        }

        public AdvancementBuilder background(ResourceLocation background) {
            this._background = background;
            return this;
        }

        public AdvancementBuilder type(FrameType type) {
            this._type = type;
            return this;
        }

        public AdvancementBuilder hideCompletely() {
            return this.hideToast().hideInChat().hide();
        }

        public AdvancementBuilder hideToast() {
            return this.showToast(false);
        }

        public AdvancementBuilder showToast(boolean show) {
            this._showToast = show;
            return this;
        }

        public AdvancementBuilder hideInChat() {
            return this.announceToChat(false);
        }

        public AdvancementBuilder announceToChat(boolean announce) {
            this._announceToChat = announce;
            return this;
        }

        public AdvancementBuilder hide() {
            return this.hidden(true);
        }

        public AdvancementBuilder hidden(boolean hidden) {
            this._hidden = hidden;
            return this;
        }

        public AdvancementBuilder orCriterions() {
            return this.criterionStrategy(RequirementsStrategy.f_15979_);
        }

        public AdvancementBuilder criterionStrategy(RequirementsStrategy strategy) {
            this._criterionStrategy = strategy;
            return this;
        }

        public AdvancementBuilder onEnterStructures(StructureRegistrar<?> ... structureRegistrars) {
            for (StructureRegistrar<?> structure : structureRegistrars) {
                this.onEnterStructure(structure);
            }
            return this;
        }

        public AdvancementBuilder onEnterStructure(@NotNull StructureRegistrar<?> structureRegistrar) {
            return this.onEnterStructure((Registrar.Pointer<Structure>)Objects.requireNonNull(structureRegistrar.getStructure()));
        }

        public AdvancementBuilder onEnterStructure(@NotNull Registrar.Pointer<Structure> structurePointer) {
            PlayerTrigger.TriggerInstance t = PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_((ResourceKey)structurePointer.getKey()));
            this._criterions.add((Pair<String, CriterionTriggerInstance>)new Pair((Object)("entered_" + structurePointer.getKey().m_135782_().m_135815_()), (Object)t));
            return this;
        }

        public Advancement save(@NotNull Consumer<Advancement> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            Advancement.Builder builder = Advancement.Builder.m_285878_().m_138362_(this._displayItem, AdvancementBuilder.component(this._id), AdvancementBuilder.component(this._id + ".desc"), this._background, this._type, this._showToast, this._announceToChat, this._hidden).m_138360_(this._criterionStrategy);
            for (Pair<String, CriterionTriggerInstance> pair : this._criterions) {
                builder.m_138386_((String)pair.getFirst(), (CriterionTriggerInstance)pair.getSecond());
            }
            if (this._parent != null) {
                builder.m_138398_(this._parent);
            }
            return builder.save(consumer, DEUtil.locate(this._id), existingFileHelper);
        }

        private static Component component(String key) {
            return Component.m_237115_((String)("advancements.dungeons_enhanced." + key));
        }
    }
}

