/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.network;

public class RateLimiter {
    private final int maxTokens;
    private final int refillRate;
    private double currentTokens;
    private long lastRefillTimestamp;

    public RateLimiter(int maxTokens, int refillRate) {
        this.maxTokens = maxTokens;
        this.refillRate = refillRate;
        this.currentTokens = maxTokens;
        this.lastRefillTimestamp = System.currentTimeMillis();
    }

    private void refillTokens() {
        long now = System.currentTimeMillis();
        long timeElapsed = now - this.lastRefillTimestamp;
        double tokensToAdd = (double)timeElapsed / 1000.0 * (double)this.refillRate;
        this.currentTokens = Math.min((double)this.maxTokens, this.currentTokens + tokensToAdd);
        this.lastRefillTimestamp = now;
    }

    public synchronized boolean tryConsume() {
        this.refillTokens();
        if (this.currentTokens >= 1.0) {
            this.currentTokens -= 1.0;
            return true;
        }
        return false;
    }
}

