/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.gui.screen;

import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.gui.screen.OverlayScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ConfirmScreen
extends Screen
implements OverlayScreen {
    public static final ResourceLocation TEXTURE = ExposureCatalog.resource("textures/gui/confirm.png");
    protected final Screen parent;
    protected final Component message;
    protected final Component yesButtonMsg;
    protected final Button.OnPress onYesButtonPress;
    protected final Component noButtonMsg;
    protected final Button.OnPress onNoButtonPress;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    private Button yesButton;
    private Button noButton;

    public ConfirmScreen(Screen parent, Component message, Component yesButtonMsg, Button.OnPress onYesButtonPress, Component noButtonMsg, Button.OnPress onNoButtonPress) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        this.message = message;
        this.yesButtonMsg = yesButtonMsg;
        this.onYesButtonPress = onYesButtonPress;
        this.noButtonMsg = noButtonMsg;
        this.onNoButtonPress = onNoButtonPress;
    }

    protected void m_7856_() {
        this.imageWidth = 240;
        this.imageHeight = 88;
        this.leftPos = this.f_96543_ / 2 - this.imageWidth / 2;
        this.topPos = this.f_96544_ / 2 - this.imageHeight / 2;
        this.yesButton = Button.m_253074_((Component)this.yesButtonMsg, button -> {
            this.m_7379_();
            this.onYesButtonPress.m_93750_(button);
        }).m_252987_(this.leftPos + 9, this.topPos + 60, 108, 19).m_253136_();
        this.m_142416_((GuiEventListener)this.yesButton);
        this.noButton = Button.m_253074_((Component)this.noButtonMsg, button -> {
            this.m_7379_();
            this.onNoButtonPress.m_93750_(button);
        }).m_252987_(this.leftPos + 123, this.topPos + 60, 108, 19).m_253136_();
        this.m_142416_((GuiEventListener)this.noButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280411_(TEXTURE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        List messageLines = this.f_96547_.m_92923_((FormattedText)this.message, 221);
        int n = messageLines.size();
        Objects.requireNonNull(this.f_96547_);
        int messageY = 28 - n * 9 / 2;
        for (int i = 0; i < messageLines.size(); ++i) {
            FormattedCharSequence messageLine = (FormattedCharSequence)messageLines.get(i);
            int n2 = this.leftPos + 120 - this.f_96547_.m_92724_(messageLine) / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280649_(this.f_96547_, messageLine, n2, this.topPos + messageY + i * 9, -12500671, false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_7222_() == null && keyCode == 257) {
            this.yesButton.m_5691_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public Screen getParent() {
        return this.parent;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.getParent());
    }
}

