/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.server;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.infrastructure.FlashMode;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.packet.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record CameraSetFlashModeC2SP(FlashMode flashMode) implements IPacket
{
    public static final ResourceLocation ID = Exposure.resource("camera_set_flash_mode");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public FriendlyByteBuf toBuffer(FriendlyByteBuf buffer) {
        this.flashMode.toBuffer(buffer);
        return buffer;
    }

    public static CameraSetFlashModeC2SP fromBuffer(FriendlyByteBuf buffer) {
        return new CameraSetFlashModeC2SP(FlashMode.fromBuffer(buffer));
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (String)"Cannot handle packet {}: Player was null", (Object)ID);
        Camera.getCamera(player).ifPresent(c -> ((CameraItem)((Object)((Object)c.get().getItem()))).setFlashMode(c.get().getStack(), this.flashMode));
        return true;
    }
}

