/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.tools.varia;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.incontrol.ErrorHandler;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Tools {
    public static ResourceKey<Level> getDimensionKey(LevelAccessor world) {
        if (world instanceof Level) {
            return ((Level)world).m_46472_();
        }
        if (world instanceof ServerLevelAccessor) {
            return ((ServerLevelAccessor)world).m_6018_().m_46472_();
        }
        throw new IllegalStateException("Not possible to get a dimension key here!");
    }

    public static String getBiomeId(Holder<Biome> biomeHolder) {
        return (String)biomeHolder.m_203439_().map(key -> key.m_135782_().toString(), key -> "[unregistered " + key + "]");
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(String name) {
        int i;
        for (i = 0; i < name.length() && (Character.isDigit(name.charAt(i)) || name.charAt(i) == '.'); ++i) {
        }
        if (i < name.length() && name.charAt(i) == '=') {
            float v;
            String f = name.substring(0, i);
            try {
                v = Float.parseFloat(f);
            }
            catch (NumberFormatException e) {
                v = 1.0f;
            }
            return Pair.of((Object)Float.valueOf(v), (Object)Tools.parseStack(name.substring(i + 1)));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Tools.parseStack(name));
    }

    public static Pair<Float, ItemStack> parseStackWithFactor(JsonObject obj) {
        ItemStack stack;
        float factor = 1.0f;
        if (obj.has("factor")) {
            factor = obj.get("factor").getAsFloat();
        }
        if ((stack = Tools.parseStack(obj)) == null) {
            return null;
        }
        return Pair.of((Object)Float.valueOf(factor), (Object)stack);
    }

    @Nonnull
    public static ItemStack parseStack(String name) {
        if (name.contains("{")) {
            CompoundTag nbt;
            int idx = name.indexOf(123);
            ItemStack stack = Tools.parseStackNoNBT(name.substring(0, idx));
            if (stack.m_41619_()) {
                return stack;
            }
            try {
                nbt = TagParser.m_129359_((String)name.substring(idx));
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing NBT in '" + name + "'!");
                return ItemStack.f_41583_;
            }
            stack.m_41751_(nbt);
            return stack;
        }
        if (name.contains("/")) {
            CompoundTag nbt;
            int idx = name.indexOf(47);
            ItemStack stack = Tools.parseStackNoNBT(name.substring(0, idx));
            if (stack.m_41619_()) {
                return stack;
            }
            try {
                nbt = TagParser.m_129359_((String)name.substring(idx + 1));
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing NBT in '" + name + "'!");
                return ItemStack.f_41583_;
            }
            stack.m_41751_(nbt);
            return stack;
        }
        return Tools.parseStackNoNBT(name);
    }

    @Nullable
    public static ItemStack parseStack(JsonObject obj) {
        if (obj.has("empty")) {
            return ItemStack.f_41583_;
        }
        String name = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            ErrorHandler.error("Unknown item '" + name + "'!");
            return null;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (obj.has("damage")) {
            stack.m_41721_(obj.get("damage").getAsInt());
        }
        if (obj.has("count")) {
            stack.m_41764_(obj.get("count").getAsInt());
        }
        if (obj.has("nbt")) {
            String nbt = obj.get("nbt").toString();
            CompoundTag tag = null;
            try {
                tag = TagParser.m_129359_((String)nbt);
            }
            catch (CommandSyntaxException e) {
                ErrorHandler.error("Error parsing json '" + nbt + "'!");
                return ItemStack.f_41583_;
            }
            stack.m_41751_(tag);
        }
        return stack;
    }

    private static ItemStack parseStackNoNBT(String name) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item);
    }

    public static ServerLevel getServerWorld(LevelAccessor world) {
        ServerLevel sw;
        if (world instanceof ServerLevel) {
            sw = (ServerLevel)world;
        } else if (world instanceof ServerLevelAccessor) {
            sw = ((ServerLevelAccessor)world).m_6018_();
        } else {
            throw new IllegalStateException("No world found!");
        }
        return sw;
    }

    public static Predicate<Integer> parseExpression(String input) {
        String i = input.toLowerCase();
        if (i.startsWith("greater(") || i.startsWith("gt(")) {
            int number = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(41)).trim());
            return value -> value > number;
        }
        if (i.startsWith("greaterorequal(") || i.startsWith("ge(")) {
            int number = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(41)).trim());
            return value -> value >= number;
        }
        if (i.startsWith("smaller(") || i.startsWith("lt(")) {
            int number = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(41)).trim());
            return value -> value < number;
        }
        if (i.startsWith("smallerorequal(") || i.startsWith("le(")) {
            int number = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(41)).trim());
            return value -> value <= number;
        }
        if (i.startsWith("equal(") || i.startsWith("eq(")) {
            int number = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(41)).trim());
            return value -> value == number;
        }
        if (i.startsWith("notequal(") || i.startsWith("ne(")) {
            int number = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(41)).trim());
            return value -> value != number;
        }
        if (i.startsWith("range(")) {
            int min = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(44)));
            int max = Integer.parseInt(i.substring(i.indexOf(44) + 1, i.indexOf(41)));
            return value -> value >= min && value <= max;
        }
        if (i.startsWith("outsiderange(")) {
            int min = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(44)));
            int max = Integer.parseInt(i.substring(i.indexOf(44) + 1, i.indexOf(41)));
            return value -> value < min || value > max;
        }
        if (i.startsWith("repeat(")) {
            int cycle = Integer.parseInt(i.substring(i.indexOf(40) + 1, i.indexOf(44)));
            int min = Integer.parseInt(i.substring(i.indexOf(44) + 1, i.lastIndexOf(44)));
            int max = Integer.parseInt(i.substring(i.lastIndexOf(44) + 1, i.indexOf(41)));
            return value -> {
                int v = value % cycle;
                return v >= min && v <= max;
            };
        }
        ErrorHandler.error("Unknown expression '" + input + "'!");
        return null;
    }
}

