/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.vtaw_mw;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractWeapon
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(AbstractWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(AbstractWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.m_135353_(AbstractWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private BlockState lastState;
    protected boolean inGround;
    protected int inGroundTime;
    public Pickup pickup = Pickup.DISALLOWED;
    public int shakeTime;
    private int life;
    private double baseDamage = 2.0;
    private int knockback;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;

    protected AbstractWeapon(EntityType<? extends AbstractWeapon> p_36721_, Level p_36722_) {
        super(p_36721_, p_36722_);
    }

    protected AbstractWeapon(EntityType<? extends AbstractWeapon> p_36711_, double p_36712_, double p_36713_, double p_36714_, Level p_36715_) {
        this(p_36711_, p_36715_);
        this.m_6034_(p_36712_, p_36713_, p_36714_);
    }

    protected AbstractWeapon(EntityType<? extends AbstractWeapon> p_36717_, LivingEntity p_36718_, Level p_36719_) {
        this(p_36717_, p_36718_.m_20185_(), p_36718_.m_20188_() - (double)0.1f, p_36718_.m_20189_(), p_36719_);
        this.m_5602_((Entity)p_36718_);
        if (p_36718_ instanceof Player) {
            this.pickup = Pickup.ALLOWED;
        }
    }

    public void setSoundEvent(SoundEvent p_36741_) {
        this.soundEvent = p_36741_;
    }

    public boolean m_6783_(double p_36726_) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_36726_ < (d0 *= 64.0 * AbstractWeapon.m_20150_()) * d0;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(PIERCE_LEVEL, (Object)0);
    }

    public void m_6686_(double p_36775_, double p_36776_, double p_36777_, float p_36778_, float p_36779_) {
        super.m_6686_(p_36775_, p_36776_, p_36777_, p_36778_, p_36779_);
        this.life = 0;
    }

    public void m_6453_(double p_36728_, double p_36729_, double p_36730_, float p_36731_, float p_36732_, int p_36733_, boolean p_36734_) {
        this.m_6034_(p_36728_, p_36729_, p_36730_);
        this.m_19915_(p_36731_, p_36732_);
    }

    public void m_6001_(double p_36786_, double p_36787_, double p_36788_) {
        super.m_6001_(p_36786_, p_36787_, p_36788_);
        this.life = 0;
    }

    protected void m_37283_() {
        super.m_37283_();
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        super.m_8119_();
        boolean flag = this.isNoPhysics();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.m_9236_().f_46443_) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            Vec3 vec32 = this.m_20182_();
            Vec3 vec33 = vec32.m_82549_(vec3);
            BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.getPierceLevel() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.isCritArrow()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(AbstractWeapon.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(AbstractWeapon.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.getWaterInertia();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    private boolean shouldFall() {
        return this.inGround && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
        this.life = 0;
    }

    public void m_6478_(MoverType p_36749_, Vec3 p_36750_) {
        super.m_6478_(p_36749_, p_36750_);
        if (p_36749_ != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        ++this.life;
        if (this.life >= 1200) {
            this.m_146870_();
        }
    }

    private void resetPiercedEntities() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    protected void m_5790_(EntityHitResult p_36757_) {
        DamageSource damagesource;
        Entity entity1;
        super.m_5790_(p_36757_);
        Entity entity = p_36757_.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                System.out.println(123);
                this.m_146870_();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.m_19879_());
        }
        if (this.isCritArrow()) {
            long j = this.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_19749_()) == null) {
            damagesource = AbstractWeapon.weapon(this, (Entity)this);
        } else {
            damagesource = AbstractWeapon.weapon(this, entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_ && this.getPierceLevel() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (this.knockback > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.doPostHurtEffects(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
                if (!this.m_9236_().f_46443_ && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, this.piercedAndKilledEntities);
                    } else if (!entity.m_6084_() && this.shotFromCrossbow()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, Arrays.asList(entity));
                    }
                }
            }
            this.m_5496_(this.soundEvent, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                System.out.println(234);
                this.m_146870_();
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.pickup == Pickup.ALLOWED) {
                    this.m_5552_(this.getPickupItem(), 0.1f);
                }
                System.out.println(1);
                this.m_146870_();
            }
        }
    }

    public static DamageSource weapon(AbstractWeapon p_19347_, @Nullable Entity p_19348_) {
        return p_19348_.m_269291_().m_269390_((Entity)p_19347_, p_19348_);
    }

    protected void m_8060_(BlockHitResult p_36755_) {
        this.lastState = this.m_9236_().m_8055_(p_36755_.m_82425_());
        super.m_8060_(p_36755_);
        Vec3 vec3 = p_36755_.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEvents.f_11685_);
        this.setShotFromCrossbow(false);
        this.resetPiercedEntities();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.f_11685_;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity p_36744_) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_36758_, Vec3 p_36759_) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)p_36758_, (Vec3)p_36759_, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_);
    }

    protected boolean m_5603_(Entity p_36743_) {
        return super.m_5603_(p_36743_) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(p_36743_.m_19879_()));
    }

    public void m_7380_(CompoundTag p_36772_) {
        super.m_7380_(p_36772_);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            p_36772_.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        p_36772_.m_128376_("life", (short)this.life);
        if (this.lastState != null) {
            p_36772_.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.lastState));
        }
        p_36772_.m_128344_("shake", (byte)this.shakeTime);
        p_36772_.m_128379_("inGround", this.inGround);
        p_36772_.m_128344_("pickup", (byte)this.pickup.ordinal());
        p_36772_.m_128347_("damage", this.baseDamage);
        p_36772_.m_128379_("crit", this.isCritArrow());
        p_36772_.m_128344_("PierceLevel", this.getPierceLevel());
        p_36772_.m_128359_("SoundEvent", BuiltInRegistries.f_256894_.m_7981_((Object)this.soundEvent).toString());
        p_36772_.m_128379_("ShotFromCrossbow", this.shotFromCrossbow());
    }

    public void m_7378_(CompoundTag p_36761_) {
        super.m_7378_(p_36761_);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)p_36761_.m_128469_("Item"));
        this.setItem(itemstack);
        this.life = p_36761_.m_128448_("life");
        if (p_36761_.m_128425_("inBlockState", 10)) {
            this.lastState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)p_36761_.m_128469_("inBlockState"));
        }
        this.shakeTime = p_36761_.m_128445_("shake") & 0xFF;
        this.inGround = p_36761_.m_128471_("inGround");
        if (p_36761_.m_128425_("damage", 99)) {
            this.baseDamage = p_36761_.m_128459_("damage");
        }
        this.pickup = Pickup.byOrdinal(p_36761_.m_128445_("pickup"));
        this.setCritArrow(p_36761_.m_128471_("crit"));
        this.setPierceLevel(p_36761_.m_128445_("PierceLevel"));
        if (p_36761_.m_128425_("SoundEvent", 8)) {
            this.soundEvent = BuiltInRegistries.f_256894_.m_6612_(new ResourceLocation(p_36761_.m_128461_("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        this.setShotFromCrossbow(p_36761_.m_128471_("ShotFromCrossbow"));
    }

    public void m_5602_(@Nullable Entity p_36770_) {
        super.m_5602_(p_36770_);
        if (p_36770_ instanceof Player) {
            this.pickup = ((Player)p_36770_).m_150110_().f_35937_ ? Pickup.CREATIVE_ONLY : Pickup.ALLOWED;
        }
    }

    public void m_6123_(Player p_36766_) {
        if (!this.m_9236_().f_46443_ && (this.inGround || this.isNoPhysics()) && this.shakeTime <= 0 && this.tryPickup(p_36766_)) {
            this.take(p_36766_, (Entity)this, 1);
            this.m_146870_();
        }
    }

    public void take(Player player, Entity p_21030_, int p_21031_) {
        if (!p_21030_.m_213877_() && !player.m_9236_().f_46443_ && (p_21030_ instanceof ItemEntity || p_21030_ instanceof AbstractWeapon || p_21030_ instanceof ExperienceOrb)) {
            ((ServerLevel)player.m_9236_()).m_7726_().m_8445_(p_21030_, (Packet)new ClientboundTakeItemEntityPacket(p_21030_.m_19879_(), player.m_19879_(), p_21031_));
        }
    }

    protected boolean tryPickup(Player p_150121_) {
        switch (this.pickup) {
            case ALLOWED: {
                return p_150121_.m_150109_().m_36054_(this.getPickupItem());
            }
            case CREATIVE_ONLY: {
                return p_150121_.m_150110_().f_35937_;
            }
        }
        return false;
    }

    protected abstract ItemStack getPickupItem();

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void setBaseDamage(double p_36782_) {
        this.baseDamage = p_36782_;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setKnockback(int p_36736_) {
        this.knockback = p_36736_;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_6380_(Pose p_36752_, EntityDimensions p_36753_) {
        return 0.13f;
    }

    public void setCritArrow(boolean p_36763_) {
        this.setFlag(1, p_36763_);
    }

    public void setPierceLevel(byte p_36768_) {
        this.f_19804_.m_135381_(PIERCE_LEVEL, (Object)p_36768_);
    }

    private void setFlag(int p_36738_, boolean p_36739_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        if (p_36739_) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 | p_36738_)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 & ~p_36738_)));
        }
    }

    public boolean isCritArrow() {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        return (b0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return (Byte)this.f_19804_.m_135370_(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity p_36746_, float p_36747_) {
        int i = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44988_, (LivingEntity)p_36746_);
        int j = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44989_, (LivingEntity)p_36746_);
        this.setBaseDamage((double)(p_36747_ * 2.0f) + this.f_19796_.m_216328_((double)this.m_9236_().m_46791_().m_19028_() * 0.11, 0.57425));
        if (i > 0) {
            this.setBaseDamage(this.getBaseDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.setKnockback(j);
        }
        if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44990_, (LivingEntity)p_36746_) > 0) {
            this.m_20254_(100);
        }
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean p_36791_) {
        this.f_19794_ = p_36791_;
        this.setFlag(2, p_36791_);
    }

    public boolean isNoPhysics() {
        if (!this.m_9236_().f_46443_) {
            return this.f_19794_;
        }
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean p_36794_) {
        this.setFlag(4, p_36794_);
    }

    public void setItem(ItemStack p_37447_) {
        if (!p_37447_.m_150930_(this.getDefaultItem()) || p_37447_.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)p_37447_.m_41777_(), p_37451_ -> p_37451_.m_41764_(1))));
        }
    }

    protected abstract Item getDefaultItem();

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public static enum Pickup {
        DISALLOWED,
        ALLOWED,
        CREATIVE_ONLY;


        public static Pickup byOrdinal(int p_36809_) {
            if (p_36809_ < 0 || p_36809_ > Pickup.values().length) {
                p_36809_ = 0;
            }
            return Pickup.values()[p_36809_];
        }
    }
}

