/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.audio;

import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioWorldSound;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.phys.Vec3;

public class AudioManager {
    private static AudioManager instance;
    private final Map<ILevelAudio, WeakReference<AudioWorldSound>> playingSounds = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new ILevelAudio.Strategy());

    public static AudioManager get() {
        if (instance == null) {
            instance = new AudioManager();
        }
        return instance;
    }

    private AudioManager() {
    }

    public void update() {
        this.playingSounds.entrySet().removeIf(entry -> {
            WeakReference soundRef = (WeakReference)entry.getValue();
            AudioWorldSound sound = (AudioWorldSound)((Object)((Object)soundRef.get()));
            return sound == null || sound.m_7801_();
        });
    }

    private boolean isPlaying(ILevelAudio audio) {
        WeakReference<AudioWorldSound> soundRef = this.playingSounds.get(audio);
        if (soundRef != null) {
            AudioWorldSound sound = (AudioWorldSound)((Object)soundRef.get());
            return sound != null && !sound.m_7801_();
        }
        return false;
    }

    public void playLevelAudio(ILevelAudio audio) {
        if (audio.getSound() == null) {
            return;
        }
        if (!audio.canPlayAudio()) {
            return;
        }
        if (this.isPlaying(audio)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.f_91073_ != null) {
            Vec3 pos = audio.getAudioPosition();
            Vec3 eye = mc.f_91074_.m_146892_();
            if (eye.m_82557_(pos) > audio.getAudioRadiusSqr()) {
                return;
            }
            AudioWorldSound sound = new AudioWorldSound(audio);
            mc.m_91106_().m_120367_((SoundInstance)sound);
            this.playingSounds.put(audio, new WeakReference<AudioWorldSound>(sound));
        }
    }

    public void resetSounds() {
        this.playingSounds.forEach((audio, soundRef) -> {
            AudioWorldSound sound = (AudioWorldSound)((Object)((Object)soundRef.get()));
            if (sound != null) {
                sound.cancel();
            }
        });
        this.playingSounds.clear();
    }

    public void updateSound(ILevelAudio audio, AudioWorldSound sound) {
        if (this.playingSounds.containsKey(audio)) {
            this.playingSounds.put(audio, new WeakReference<AudioWorldSound>(sound));
        }
    }
}

