/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.block.IKitchenCabinetry;
import com.mrcrayfish.furniture.refurbished.blockentity.KitchenDrawerBlockEntity;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class KitchenDrawerBlock
extends FurnitureHorizontalEntityBlock
implements IKitchenCabinetry {
    public KitchenDrawerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape baseShape = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
        VoxelShape drawShape = Block.m_49796_((double)-3.0, (double)7.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            if (open) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(drawShape, direction));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof KitchenDrawerBlockEntity) {
                KitchenDrawerBlockEntity drawer = (KitchenDrawerBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)drawer);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KitchenDrawerBlockEntity(pos, state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KitchenDrawerBlockEntity) {
            KitchenDrawerBlockEntity blockEntity2 = (KitchenDrawerBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.m_61143_((Property)DIRECTION);
    }
}

