/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities.models;

import com.lion.graveyard.entities.CorruptedIllager;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CorruptedIllagerModel<T extends CorruptedIllager>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart arms;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart shortLeftArm;
    private final ModelPart leftArmStomp;

    public CorruptedIllagerModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.hat.f_104207_ = false;
        this.arms = root.m_171324_("arms");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
        this.shortLeftArm = root.m_171324_("short_left_arm");
        this.leftArmStomp = root.m_171324_("left_arm_stomp");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData2 = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData2.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.45f)), PartPose.f_171404_);
        modelPartData2.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData3 = modelPartData.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171481_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).m_171514_(40, 38).m_171481_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        modelPartData3.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.f_171404_);
        modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        modelPartData.m_171599_("short_left_arm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 7.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        modelPartData.m_171599_("left_arm_stomp", CubeListBuilder.m_171558_().m_171514_(48, 18).m_171481_(0.0f, 5.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setAngles(T illagerEntity, float f, float g, float h, float i, float j) {
        this.head.f_104204_ = i * ((float)Math.PI / 180);
        this.head.f_104203_ = j * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.rightArm.f_104203_ = -0.62831855f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -0.62831855f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.shortLeftArm.f_104203_ = -0.62831855f;
            this.leftArmStomp.f_104203_ = -0.62831855f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 2.0f * g * 0.5f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 2.0f * g * 0.5f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.shortLeftArm.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 2.0f * g * 0.5f;
            this.leftArmStomp.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 2.0f * g * 0.5f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.4f * g * 0.5f;
            this.rightLeg.f_104204_ = 0.0f;
            this.rightLeg.f_104205_ = 0.0f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * g * 0.5f;
            this.leftLeg.f_104204_ = 0.0f;
            this.leftLeg.f_104205_ = 0.0f;
        }
        CorruptedIllager.State state = ((CorruptedIllager)((Object)illagerEntity)).getState();
        this.leftArmStomp.f_104207_ = false;
        this.shortLeftArm.f_104207_ = false;
        if (state == CorruptedIllager.State.ATTACKING) {
            if (illagerEntity.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.f_102608_, (float)h);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.rightArm, (ModelPart)this.leftArm, illagerEntity, (float)this.f_102608_, (float)h);
            }
        } else if (state == CorruptedIllager.State.SPELLCASTING) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(h * 0.6662f)) * 0.25f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(h * 0.6662f)) * 0.25f;
            this.rightArm.f_104205_ = 2.3561945f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
        } else if (state == CorruptedIllager.State.BOW_AND_ARROW) {
            this.rightArm.f_104204_ = -0.1f + this.head.f_104204_;
            this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
            this.leftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
            this.leftArm.f_104204_ = this.head.f_104204_ - 0.4f;
            this.leftArm.f_104205_ = 1.5707964f;
        } else if (state == CorruptedIllager.State.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
        } else if (state == CorruptedIllager.State.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, illagerEntity, (boolean)true);
        } else if (state == CorruptedIllager.State.CELEBRATING) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(h * 0.6662f)) * 0.05f;
            this.rightArm.f_104205_ = 2.670354f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(h * 0.6662f)) * 0.05f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.leftArm.f_104204_ = 0.0f;
            this.shortLeftArm.f_104200_ = 5.0f;
            this.shortLeftArm.f_104203_ = Mth.m_14089_((float)(h * 0.6662f)) * 0.05f;
            this.shortLeftArm.f_104205_ = -2.3561945f;
            this.leftArmStomp.f_104200_ = 5.0f;
            this.leftArmStomp.f_104203_ = Mth.m_14089_((float)(h * 0.6662f)) * 0.05f;
            this.leftArmStomp.f_104205_ = -2.3561945f;
        } else if (state == CorruptedIllager.State.UNDEAD) {
            if (((CorruptedIllager)((Object)illagerEntity)).isModelDamaged()) {
                this.shortLeftArm.f_104207_ = true;
                this.leftArmStomp.f_104207_ = true;
                this.arms.f_104207_ = false;
                this.leftArm.f_104207_ = false;
            }
            AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)false, (float)this.f_102608_, (float)h);
        } else if (state == CorruptedIllager.State.UNDEAD_ATTACKING) {
            if (((CorruptedIllager)((Object)illagerEntity)).isModelDamaged()) {
                this.shortLeftArm.f_104207_ = true;
                this.leftArmStomp.f_104207_ = true;
                this.leftArm.f_104207_ = false;
            }
            AnimationUtils.m_102102_((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)true, (float)this.f_102608_, (float)h);
        }
        if (!((CorruptedIllager)((Object)illagerEntity)).isModelDamaged()) {
            boolean bl;
            this.arms.f_104207_ = bl = state == CorruptedIllager.State.CROSSED;
            this.leftArm.f_104207_ = !bl;
            this.rightArm.f_104207_ = !bl;
        }
    }

    private ModelPart getAttackingArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHat() {
        return this.hat;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm arm, PoseStack matrices) {
        this.getAttackingArm(arm).m_104299_(matrices);
    }
}

