/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.CorruptedIllager;
import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.init.TGAdvancements;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class HordeGraveyardEntity
extends HostileGraveyardEntity {
    private BlockPos patrolTarget;
    private boolean patrolling;
    private boolean patrolLeader;

    protected HordeGraveyardEntity(EntityType<? extends Monster> entityType, Level world, String name) {
        super(entityType, world, name);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new PatrolApproachGoal(this, 10.0f));
        this.f_21345_.m_25352_(4, new PatrolGoal<HordeGraveyardEntity>(this, 1.0, 0.9));
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.patrolTarget != null) {
            nbt.m_128365_("PatrolTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.patrolTarget));
        }
        nbt.m_128379_("PatrolLeader", this.patrolLeader);
        nbt.m_128379_("Patrolling", this.patrolling);
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("PatrolTarget")) {
            this.patrolTarget = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("PatrolTarget"));
        }
        this.patrolLeader = nbt.m_128471_("PatrolLeader");
        this.patrolling = nbt.m_128471_("Patrolling");
    }

    public double m_6049_() {
        return -0.45;
    }

    public boolean canLead() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        if (spawnReason != MobSpawnType.PATROL && spawnReason != MobSpawnType.EVENT && spawnReason != MobSpawnType.STRUCTURE && this.f_19796_.m_188501_() < 0.06f && this.canLead()) {
            this.patrolLeader = true;
        }
        if (spawnReason == MobSpawnType.PATROL) {
            this.patrolling = true;
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean m_6785_(double distanceSquared) {
        return !this.patrolling || distanceSquared > 16384.0;
    }

    public void setPatrolTarget(BlockPos targetPos) {
        this.patrolTarget = targetPos;
        this.patrolling = true;
    }

    public void setPatrolLeader(boolean patrolLeader) {
        this.patrolLeader = patrolLeader;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setRandomPatrolTarget() {
        this.patrolTarget = this.m_20183_().m_7918_(-500 + this.f_19796_.m_188503_(1000), 0, -500 + this.f_19796_.m_188503_(1000));
        this.patrolling = true;
    }

    protected void setPatrolling(boolean patrolling) {
        this.patrolling = patrolling;
    }

    public boolean hasNoRaid() {
        return true;
    }

    protected boolean isRaidCenterSet() {
        return this.patrolling;
    }

    protected void m_21268_(@Nullable LivingEntity adversary) {
        if (adversary instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)adversary;
            if (this.patrolLeader) {
                TGAdvancements.KILL_HORDE.trigger(player);
            }
        }
        super.m_21268_(adversary);
    }

    protected class PatrolApproachGoal
    extends Goal {
        private final HordeGraveyardEntity hordeEntity;
        private final float squaredDistance;
        public final TargetingConditions closeRaiderPredicate = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_();

        public PatrolApproachGoal(HordeGraveyardEntity hordeEntity, float distance) {
            this.hordeEntity = hordeEntity;
            this.squaredDistance = distance * distance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.hordeEntity.m_21188_();
            return this.hordeEntity.isRaidCenterSet() && this.hordeEntity.m_5448_() != null && !this.hordeEntity.m_5912_() && (livingEntity == null || livingEntity.m_6095_() != EntityType.f_20532_);
        }

        public void m_8056_() {
            super.m_8056_();
            this.hordeEntity.m_21573_().m_26573_();
            List list = this.hordeEntity.m_20193_().m_45971_(HordeGraveyardEntity.class, this.closeRaiderPredicate, (LivingEntity)this.hordeEntity, this.hordeEntity.m_20191_().m_82377_(8.0, 8.0, 8.0));
            for (HordeGraveyardEntity hordeEntityEntity : list) {
                hordeEntityEntity.m_6710_(this.hordeEntity.m_5448_());
            }
        }

        public void m_8041_() {
            super.m_8041_();
            LivingEntity livingEntity = this.hordeEntity.m_5448_();
            if (livingEntity != null) {
                List list = this.hordeEntity.m_20193_().m_45971_(HordeGraveyardEntity.class, this.closeRaiderPredicate, (LivingEntity)this.hordeEntity, this.hordeEntity.m_20191_().m_82377_(8.0, 8.0, 8.0));
                for (HordeGraveyardEntity hordeEntityEntity : list) {
                    hordeEntityEntity.m_6710_(livingEntity);
                    hordeEntityEntity.m_21561_(true);
                }
                this.hordeEntity.m_21561_(true);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.hordeEntity.m_5448_();
            if (livingEntity != null) {
                if (this.hordeEntity.m_20280_((Entity)livingEntity) > (double)this.squaredDistance) {
                    this.hordeEntity.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
                    if (this.hordeEntity.f_19796_.m_188503_(50) == 0) {
                        this.hordeEntity.m_8032_();
                    }
                } else {
                    this.hordeEntity.m_21561_(true);
                }
                super.m_8037_();
            }
        }
    }

    public static class PatrolGoal<T extends HordeGraveyardEntity>
    extends Goal {
        private final T entity;
        private final double leaderSpeed;
        private final double followSpeed;
        private long nextPatrolSearchTime;

        public PatrolGoal(T entity, double leaderSpeed, double followSpeed) {
            this.entity = entity;
            if (entity instanceof CorruptedIllager) {
                this.leaderSpeed = leaderSpeed - 0.5;
                this.followSpeed = followSpeed - 0.5;
            } else {
                this.leaderSpeed = leaderSpeed;
                this.followSpeed = followSpeed;
            }
            this.nextPatrolSearchTime = -1L;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            boolean bl = this.entity.m_20193_().m_46467_() < this.nextPatrolSearchTime;
            return ((HordeGraveyardEntity)((Object)this.entity)).isRaidCenterSet() && this.entity.m_5448_() == null && !this.entity.m_20160_() && ((HordeGraveyardEntity)((Object)this.entity)).hasPatrolTarget() && !bl;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            boolean bl = ((HordeGraveyardEntity)((Object)this.entity)).isPatrolLeader();
            PathNavigation entityNavigation = this.entity.m_21573_();
            if (entityNavigation.m_26571_()) {
                List<HordeGraveyardEntity> list = this.findPatrolTargets();
                if (((HordeGraveyardEntity)((Object)this.entity)).isRaidCenterSet() && list.isEmpty()) {
                    ((HordeGraveyardEntity)((Object)this.entity)).setPatrolling(false);
                } else if (bl && ((HordeGraveyardEntity)((Object)this.entity)).getPatrolTarget().m_203195_((Position)this.entity.m_20182_(), 10.0)) {
                    ((HordeGraveyardEntity)((Object)this.entity)).setRandomPatrolTarget();
                } else {
                    Vec3 vec3d = Vec3.m_82539_((Vec3i)((HordeGraveyardEntity)((Object)this.entity)).getPatrolTarget());
                    Vec3 vec3d2 = this.entity.m_20182_();
                    Vec3 vec3d3 = vec3d2.m_82546_(vec3d);
                    vec3d = vec3d3.m_82524_(90.0f).m_82490_(0.4).m_82549_(vec3d);
                    Vec3 vec3d4 = vec3d.m_82546_(vec3d2).m_82541_().m_82490_(10.0).m_82549_(vec3d2);
                    BlockPos blockPos = BlockPos.m_274446_((Position)vec3d4);
                    blockPos = this.entity.m_20193_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos);
                    if (!entityNavigation.m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), bl ? this.followSpeed : this.leaderSpeed)) {
                        this.wander();
                        this.nextPatrolSearchTime = this.entity.m_20193_().m_46467_() + 200L;
                    } else if (bl) {
                        for (HordeGraveyardEntity patrolEntity : list) {
                            patrolEntity.setPatrolTarget(blockPos);
                        }
                    }
                }
            }
        }

        private List<HordeGraveyardEntity> findPatrolTargets() {
            return this.entity.m_20193_().m_6443_(HordeGraveyardEntity.class, this.entity.m_20191_().m_82400_(16.0), patrolEntity -> patrolEntity.hasNoRaid() && !patrolEntity.m_7306_((Entity)this.entity));
        }

        private boolean wander() {
            Random random = new Random();
            BlockPos blockPos = this.entity.m_20193_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.entity.m_20183_().m_7918_(-8 + random.nextInt(16), 0, -8 + random.nextInt(16)));
            return this.entity.m_21573_().m_26519_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), this.leaderSpeed);
        }
    }
}

