/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.entities.goals;

import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import de.cadentem.cave_dweller.entities.goals.Roll;
import de.cadentem.cave_dweller.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CaveDwellerStareGoal
extends Goal {
    private final CaveDwellerEntity caveDweller;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public CaveDwellerStareGoal(CaveDwellerEntity caveDweller) {
        this.caveDweller = caveDweller;
        this.lookedAtMax = caveDweller.m_217043_().m_216332_(8, 15);
    }

    public boolean m_8036_() {
        if (this.caveDweller.m_20145_()) {
            return false;
        }
        if (!Utils.isValidPlayer((Entity)this.caveDweller.m_5448_())) {
            return false;
        }
        return this.caveDweller.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidPlayer((Entity)this.caveDweller.m_5448_())) {
            return false;
        }
        return this.caveDweller.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.caveDweller.pleaseStopMoving = false;
        this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.SPOTTED_ACCESSOR, (Object)false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.caveDweller.m_5448_();
        if (target == null) {
            this.caveDweller.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.caveDweller.targetIsFacingMe && target.m_142582_((Entity)this.caveDweller);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax && !actuallyLooking) {
            if (this.caveDweller.m_217043_().m_188500_() < 0.1) {
                this.caveDweller.disappear();
            } else if (this.caveDweller.m_217043_().m_188500_() < 0.3) {
                this.caveDweller.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.caveDweller.pleaseStopMoving = false;
            this.caveDweller.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.caveDweller.pleaseStopMoving = true;
            this.caveDweller.m_21573_().m_26573_();
            this.caveDweller.m_20256_(Vec3.f_82478_);
        }
        this.caveDweller.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

