/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.popcraft.chunky.nbt.Tag;

public final class NBT {
    private NBT() {
    }

    public static Tag load(InputStream inputStream) throws IOException {
        DataInputStream dataInput = new DataInputStream(inputStream);
        return Tag.load(dataInput);
    }

    public static void save(OutputStream outputStream, Tag tag) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(outputStream);
        Tag.save(dataOutput, tag);
    }

    public static Tag loadCompressed(InputStream inputStream) throws IOException {
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);){
            DataInputStream dataInput = new DataInputStream(gzipInputStream);
            Tag tag = Tag.load(dataInput);
            return tag;
        }
    }

    public static void saveCompressed(OutputStream outputStream, Tag tag) throws IOException {
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
            DataOutputStream dataOutput = new DataOutputStream(gzipOutputStream);
            Tag.save(dataOutput, tag);
        }
    }
}

