/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.tracker;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.data.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.util.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class UnlockTracker
implements Serializable {
    private final Set<ResourceLocation> unlockedBackpacks = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, IProgressTracker> progressTrackerMap;

    public UnlockTracker() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BackpackManager.instance().getRegisteredBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker();
            if (tracker != null) {
                builder.put((Object)backpack.getId(), (Object)tracker);
            }
        });
        this.progressTrackerMap = builder.build();
    }

    public Set<ResourceLocation> getUnlockedBackpacks() {
        return Collections.unmodifiableSet(this.unlockedBackpacks);
    }

    public Map<ResourceLocation, IProgressTracker> getProgressTrackerMap() {
        return this.progressTrackerMap;
    }

    void setUnlockedBackpacks(Set<ResourceLocation> unlockedBackpacks) {
        this.unlockedBackpacks.clear();
        this.unlockedBackpacks.addAll(unlockedBackpacks);
    }

    public boolean isUnlocked(ResourceLocation id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(ResourceLocation id) {
        if (!((Boolean)Config.SERVER.common.unlockAllBackpacks.get()).booleanValue() && !this.unlockedBackpacks.contains(id)) {
            return Optional.ofNullable(this.progressTrackerMap.get(id));
        }
        return Optional.empty();
    }

    public boolean unlockBackpack(ResourceLocation id) {
        if (BackpackManager.instance().getBackpack(id) != null) {
            return this.unlockedBackpacks.add(id);
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ListTag unlockedBackpacks = new ListTag();
        this.unlockedBackpacks.forEach(location -> unlockedBackpacks.add((Object)StringTag.m_129297_((String)location.toString())));
        tag.m_128365_("UnlockedBackpacks", (Tag)unlockedBackpacks);
        ListTag progressTrackers = new ListTag();
        this.progressTrackerMap.forEach((location, progressTracker) -> {
            CompoundTag progressTag = new CompoundTag();
            progressTag.m_128359_("Id", location.toString());
            CompoundTag dataTag = new CompoundTag();
            progressTracker.write(dataTag);
            progressTag.m_128365_("Data", (Tag)dataTag);
            progressTrackers.add((Object)progressTag);
        });
        tag.m_128365_("ProgressTrackers", (Tag)progressTrackers);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.unlockedBackpacks.clear();
        ListTag unlockedBackpacks = tag.m_128437_("UnlockedBackpacks", 8);
        unlockedBackpacks.forEach(t -> this.unlockedBackpacks.add(ResourceLocation.m_135820_((String)t.m_7916_())));
        ListTag progressTrackers = tag.m_128437_("ProgressTrackers", 10);
        progressTrackers.forEach(t -> {
            CompoundTag progressTag = (CompoundTag)t;
            ResourceLocation id = new ResourceLocation(progressTag.m_128461_("Id"));
            IProgressTracker tracker = this.progressTrackerMap.get(id);
            if (tracker != null) {
                CompoundTag dataTag = progressTag.m_128469_("Data");
                tracker.read(dataTag);
            }
        });
    }
}

