/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import com.mrcrayfish.backpacked.block.ShelfBlock;
import com.mrcrayfish.backpacked.blockentity.IOptionalStorage;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModSounds;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.BlockEntityUtil;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ShelfBlockEntity
extends BlockEntity
implements IOptionalStorage {
    private ItemStack backpack = ItemStack.f_41583_;
    private SimpleContainer inventory = null;

    public ShelfBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ShelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHELF.get(), pos, state);
    }

    @Override
    @Nullable
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public ItemStack getBackpackWithContents() {
        ItemStack stack = this.backpack.m_41777_();
        if (!stack.m_41619_()) {
            this.copyInventoryToStack(stack);
        }
        return stack;
    }

    public InteractionResult interact(Player player) {
        if (player.m_6047_() || this.backpack.m_41619_()) {
            ItemStack stack = Services.BACKPACK.getBackpackStack(player);
            if (!stack.m_41619_() && !(stack.m_41720_() instanceof BackpackItem)) {
                if (!this.backpack.m_41619_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.backpacked.occupied_back_slot"), true);
                }
                return InteractionResult.FAIL;
            }
            ItemStack result = this.shelveBackpack(stack);
            Services.BACKPACK.setBackpackStack(player, result);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openBackpackInventory(serverPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemStack shelveBackpack(ItemStack stack) {
        ItemStack shelvedBackpack = this.backpack.m_41777_();
        this.copyInventoryToStack(shelvedBackpack);
        this.backpack = stack.m_41777_();
        if (!this.backpack.m_41619_() || !shelvedBackpack.m_41619_()) {
            boolean removed = this.backpack.m_41619_();
            this.updateInventory(false);
            BlockEntityUtil.sendUpdatePacket(this);
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ITEM_BACKPACK_PLACE.get(), SoundSource.BLOCKS, 1.0f, removed ? 0.75f : 1.0f);
            this.m_6596_();
        }
        return shelvedBackpack;
    }

    private void openBackpackInventory(ServerPlayer player) {
        this.getBackpackInventory().ifPresent(inventory -> this.getBackpackItem().ifPresent(backpackItem -> {
            Component title = this.backpack.m_41788_() ? this.backpack.m_41786_() : BackpackItem.BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            Services.BACKPACK.openBackpackScreen(player, (Container)inventory, cols, rows, false, title);
        }));
    }

    private void copyInventoryToStack(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.getBackpackInventory().ifPresent(inventory -> stack.m_41784_().m_128365_("Items", (Tag)InventoryHelper.saveAllItems(new ListTag(), inventory)));
        }
    }

    private Optional<SimpleContainer> getBackpackInventory() {
        if (this.backpack.m_41619_()) {
            return Optional.empty();
        }
        if (this.inventory != null && this.inventory.m_6643_() != this.getBackpackSize()) {
            this.updateInventory(true);
        }
        return Optional.ofNullable(this.inventory);
    }

    private void updateInventory(boolean resized) {
        if (!this.backpack.m_41619_()) {
            SimpleContainer oldInventory = this.inventory;
            this.inventory = new ShelfContainer(this.getBackpackSize());
            CompoundTag compound = this.backpack.m_41784_();
            this.loadBackpackItems(compound);
            compound.m_128473_("Items");
            if (resized && oldInventory != null) {
                InventoryHelper.mergeInventory(oldInventory, this.inventory, this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_));
            }
        } else {
            this.inventory = null;
        }
    }

    private void loadBackpackItems(CompoundTag compound) {
        if (compound.m_128425_("Items", 9)) {
            InventoryHelper.loadAllItems(compound.m_128437_("Items", 10), this.inventory, this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.backpack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Backpack"));
        this.inventory = this.backpack.m_41619_() ? null : new ShelfContainer(this.getBackpackSize());
        this.loadBackpackItems(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Backpack", (Tag)this.backpack.m_41739_(new CompoundTag()));
        if (this.inventory != null) {
            ListTag items = new ListTag();
            InventoryHelper.saveAllItems(items, this.inventory);
            tag.m_128365_("Items", (Tag)items);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)ShelfBlock.f_54117_);
    }

    private Optional<BackpackItem> getBackpackItem() {
        if (this.backpack.m_41720_() instanceof BackpackItem) {
            return Optional.of((BackpackItem)this.backpack.m_41720_());
        }
        return Optional.empty();
    }

    private int getBackpackSize() {
        return this.getBackpackItem().map(item -> item.getRowCount() * item.getColumnCount()).orElse(0);
    }

    @Override
    public boolean m_7013_(int index, ItemStack stack) {
        return !BackpackSlot.isBannedItem(stack);
    }

    public class ShelfContainer
    extends SimpleContainer {
        public ShelfContainer(int size) {
            super(size);
        }

        public void m_6596_() {
            super.m_6596_();
            ShelfBlockEntity.this.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return ShelfBlockEntity.this.inventory == this && !ShelfBlockEntity.this.backpack.m_41619_() && !ShelfBlockEntity.this.f_58859_;
        }
    }
}

