/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.mrcrayfish.backpacked.Bootstrap;
import com.mrcrayfish.backpacked.client.ClientBootstrap;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.data.pickpocket.ForgePickpocketChallenge;
import com.mrcrayfish.backpacked.data.tracker.ForgeUnlockTracker;
import com.mrcrayfish.backpacked.datagen.BlockTagGen;
import com.mrcrayfish.backpacked.datagen.LootTableGen;
import com.mrcrayfish.backpacked.datagen.RecipeGen;
import com.mrcrayfish.backpacked.enchantment.LootedEnchantment;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="backpacked")
public class Backpacked {
    public static final EnchantmentCategory ENCHANTMENT_TYPE = EnchantmentCategory.create((String)"backpack", item -> item instanceof BackpackItem);
    private static boolean controllableLoaded = false;
    private static boolean curiosLoaded = false;

    public Backpacked() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.addListener(ClientHandler::onRegisterLayerDefinitions);
            bus.addListener(ClientHandler::onRegisterRenderers);
            bus.addListener(ClientHandler::onAddLayers);
        });
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onClientSetup);
        bus.addListener(this::onGatherData);
        bus.addListener(ForgeUnlockTracker::registerCapability);
        bus.addListener(ForgePickpocketChallenge::registerCapability);
        MinecraftForge.EVENT_BUS.register((Object)this);
        controllableLoaded = ModList.get().isLoaded("controllable");
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(Bootstrap::init);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClientBootstrap.init();
            ClientHandler.init();
        });
    }

    private void onGatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagGen(packOutput, lookupProvider, existingFileHelper));
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (curiosLoaded) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Inventory inventory = oldPlayer.m_150109_();
        if (inventory instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory1 = (ExtendedPlayerInventory)inventory;
            inventory = event.getEntity().m_150109_();
            if (inventory instanceof ExtendedPlayerInventory) {
                ExtendedPlayerInventory inventory2 = (ExtendedPlayerInventory)inventory;
                inventory2.copyBackpack(inventory1);
            }
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        ExtendedPlayerInventory inventory;
        ItemStack backpack;
        if (curiosLoaded) {
            return;
        }
        Player player = event.getEntity();
        Inventory inventory2 = player.m_150109_();
        if (inventory2 instanceof ExtendedPlayerInventory && !(backpack = (ItemStack)(inventory = (ExtendedPlayerInventory)inventory2).getBackpackItems().get(0)).m_41619_() && backpack.m_41720_() instanceof BackpackItem) {
            Network.getPlay().sendToTracking(() -> player, (IMessage)new MessageUpdateBackpack(player.m_19879_(), backpack));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Inventory inventory;
        if (curiosLoaded) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        if (!player.m_9236_().f_46443_ && (inventory = player.m_150109_()) instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory2 = (ExtendedPlayerInventory)inventory;
            if (!((ItemStack)inventory2.backpackArray.get(0)).equals(inventory2.backpackInventory.get(0))) {
                Network.getPlay().sendToTracking(() -> player, (IMessage)new MessageUpdateBackpack(player.m_19879_(), (ItemStack)inventory2.backpackInventory.get(0)));
                inventory2.backpackArray.set(0, (Object)((ItemStack)inventory2.backpackInventory.get(0)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDropLoot(LivingDropsEvent event) {
        if (LootedEnchantment.onDropLoot(event.getDrops(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (WanderingTraderEvents.onInteract(event.getTarget(), event.getEntity())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean isControllableLoaded() {
        return controllableLoaded;
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }
}

