/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.bridges;

import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.item.BlockItemFuel;
import fr.samlegamer.addonslib.item.BlockItemFuelInfo;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class Bridges {
    private static final BlockBehaviour.Properties wood = BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 2.5f).m_60918_(SoundType.f_56736_);
    private static final BlockBehaviour.Properties stone = BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56742_);
    public static final String modid = "mcwbridges";
    private static final String desc = "mcwbridges.bridges.desc";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Bridges.setRegistrationWoodModLoaded(set, block, item, wood);
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Bridges.setRegistrationRockModLoaded(set, block, item, stone);
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        for (String i : set) {
            try {
                RegistryObject<Block> balustrade_cryptic_stone_bridge;
                RegistryObject<Block> cryptic_stone_bridge_stair;
                RegistryObject<Block> cryptic_stone_bridge_pier;
                RegistryObject<Block> cryptic_stone_bridge;
                if (ModList.get().isLoaded(modid)) {
                    cryptic_stone_bridge = Bridges.createBlockStone(i + "_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block", STONE), block, item);
                    cryptic_stone_bridge_pier = Bridges.createBlockStone(i + "_bridge_pier", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Support", STONE), block, item);
                    cryptic_stone_bridge_stair = Bridges.createBlockStone(i + "_bridge_stair", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", STONE), block, item);
                    balustrade_cryptic_stone_bridge = Bridges.createBlockStone("balustrade_" + i + "_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block", STONE), block, item);
                    continue;
                }
                cryptic_stone_bridge = Bridges.createBlockStone(i + "_bridge", () -> new Block(STONE), block, item);
                cryptic_stone_bridge_pier = Bridges.createBlockStone(i + "_bridge_pier", () -> new Block(STONE), block, item);
                cryptic_stone_bridge_stair = Bridges.createBlockStone(i + "_bridge_stair", () -> new Block(STONE), block, item);
                balustrade_cryptic_stone_bridge = Bridges.createBlockStone("balustrade_" + i + "_bridge", () -> new Block(STONE), block, item);
            }
            catch (Exception e) {
                AddonsLib.LOGGER.error((Object)e);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        BlockBehaviour.Properties RAILS = prop.m_60955_();
        for (String i : set) {
            try {
                RegistryObject<Block> rail_bridge;
                RegistryObject<Block> rope_bridge_stair;
                RegistryObject<Block> log_bridge_stair;
                RegistryObject<Block> bridge_pier;
                RegistryObject<Block> rope_bridge;
                RegistryObject<Block> log_bridge_middle;
                if (ModList.get().isLoaded(modid)) {
                    log_bridge_middle = Bridges.createBlock(i + "_log_bridge_middle", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Log_Bridge", WOOD), block, item);
                    rope_bridge = Bridges.createBlock("rope_" + i + "_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Block_Rope", WOOD), block, item);
                    bridge_pier = Bridges.createBlock(i + "_bridge_pier", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Support", WOOD), block, item);
                    log_bridge_stair = Bridges.createBlock(i + "_log_bridge_stair", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", WOOD), block, item);
                    rope_bridge_stair = Bridges.createBlock(i + "_rope_bridge_stair", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Bridge_Stairs", WOOD), block, item);
                    rail_bridge = Bridges.createBlock(i + "_rail_bridge", () -> Registration.getBlocksField("com.mcwbridges.kikoz.objects.Rail_Bridge", WOOD), block, item);
                    continue;
                }
                log_bridge_middle = Bridges.createBlock(i + "_log_bridge_middle", () -> new Block(WOOD), block, item);
                rope_bridge = Bridges.createBlock("rope_" + i + "_bridge", () -> new Block(WOOD), block, item);
                bridge_pier = Bridges.createBlock(i + "_bridge_pier", () -> new Block(WOOD), block, item);
                log_bridge_stair = Bridges.createBlock(i + "_log_bridge_stair", () -> new Block(WOOD), block, item);
                rope_bridge_stair = Bridges.createBlock(i + "_rope_bridge_stair", () -> new Block(WOOD), block, item);
                rail_bridge = Bridges.createBlock(i + "_rail_bridge", () -> new Block(RAILS), block, item);
            }
            catch (Exception e) {
                AddonsLib.LOGGER.error((Object)e);
            }
        }
    }

    protected static RegistryObject<Block> createBlock(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        if (name.contains("log_bridge_middle") || name.startsWith("rope_")) {
            ITEMS_REGISTRY.register(name, () -> new BlockItemFuelInfo((Block)block.get(), new Item.Properties(), desc));
        } else {
            ITEMS_REGISTRY.register(name, () -> new BlockItemFuel((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    protected static RegistryObject<Block> createBlockStone(String name, Supplier<? extends Block> supplier, DeferredRegister<Block> BLOCKS_REGISTRY, DeferredRegister<Item> ITEMS_REGISTRY) {
        RegistryObject block = BLOCKS_REGISTRY.register(name, supplier);
        ITEMS_REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        Bridges.addToTabModLoaded(event, MODID, WOOD, tab, "minecraft");
    }

    public static void addToTabModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : WOOD) {
                Block log_bridge_middle = Finder.findBlock(MODID, i + "_log_bridge_middle");
                Block rope_bridge = Finder.findBlock(MODID, "rope_" + i + "_bridge");
                Block bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block log_bridge_stair = Finder.findBlock(MODID, i + "_log_bridge_stair");
                Block rope_bridge_stair = Finder.findBlock(MODID, i + "_rope_bridge_stair");
                Block rail_bridge = Finder.findBlock(MODID, i + "_rail_bridge");
                event.m_246326_((ItemLike)log_bridge_middle);
                event.m_246326_((ItemLike)rope_bridge);
                event.m_246326_((ItemLike)bridge_pier);
                event.m_246326_((ItemLike)log_bridge_stair);
                event.m_246326_((ItemLike)rope_bridge_stair);
                event.m_246326_((ItemLike)rail_bridge);
            }
        }
    }

    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        Bridges.addToTabStoneModLoaded(event, MODID, STONE, tab, "minecraft");
    }

    public static void addToTabStoneModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : STONE) {
                Block stone_bridge = Finder.findBlock(MODID, i + "_bridge");
                Block stone_bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block stone_bridge_stair = Finder.findBlock(MODID, i + "_bridge_stair");
                Block balustrade_stone_bridge = Finder.findBlock(MODID, "balustrade_" + i + "_bridge");
                event.m_246326_((ItemLike)stone_bridge);
                event.m_246326_((ItemLike)stone_bridge_pier);
                event.m_246326_((ItemLike)stone_bridge_stair);
                event.m_246326_((ItemLike)balustrade_stone_bridge);
            }
        }
    }
}

