/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.eyes.config;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.slf4j.Logger;

public class BiomeRules {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicReference<List<Rule>> rules = new AtomicReference(new ArrayList());

    static void parseRules(List<? extends String> dimensionRules) {
        ArrayList<Rule> list = new ArrayList<Rule>();
        dimensionRules.forEach(r -> {
            Rule parse = BiomeRules.parse(r);
            if (parse != null) {
                list.add(parse);
            }
        });
        list.add(BiomeRules.disallowVoidBiomes());
        rules.set(list);
    }

    public static boolean isBiomeAllowed(ServerLevel level, Holder<Biome> key) {
        for (Rule rule : rules.get()) {
            if (!rule.test(level, key)) continue;
            return rule.allow;
        }
        return true;
    }

    @Nullable
    private static Rule parse(String rule) {
        boolean allow = true;
        if (rule.startsWith("!")) {
            allow = false;
            rule = rule.substring(1);
        }
        if (rule.startsWith("#")) {
            LOGGER.warn("Invalid biome rule. Dictionary labels don't exist anymore! Please use tag rules instead.");
            return null;
        }
        if (rule.startsWith("$")) {
            return new Rule(allow, null, rule.substring(1));
        }
        if (rule.equals("*")) {
            return new Rule(allow, null, null);
        }
        return new Rule(allow, rule, null);
    }

    private static Rule disallowVoidBiomes() {
        return new Rule(false, null, "forge:is_void");
    }

    private static class Rule {
        public final boolean allow;
        public final ResourceLocation registryName;
        public final TagKey<Biome> tagKey;

        private Rule(boolean allow, @Nullable String registryName, @Nullable String tagName) {
            this.allow = allow;
            this.registryName = registryName != null ? new ResourceLocation(registryName) : null;
            this.tagKey = tagName != null ? TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(tagName)) : null;
        }

        public boolean test(ServerLevel level, Holder<Biome> biome) {
            if (this.registryName != null) {
                ResourceLocation name = (ResourceLocation)biome.m_203439_().map(ResourceKey::m_135782_, b -> level.m_9598_().m_175515_(Registries.f_256952_).m_7981_(b));
                return this.registryName.equals((Object)name);
            }
            if (this.tagKey != null) {
                return biome.m_203656_(this.tagKey);
            }
            return true;
        }
    }
}

