/*
 * Decompiled with CFR 0.152.
 */
package anomaly.init;

import anomaly.entity.AnomalyBaseEntity;
import anomaly.entity.AnomalyChaseEntity;
import anomaly.entity.AnomalyDiamondEntity;
import anomaly.entity.AnomalyGhostEntity;
import anomaly.entity.SoundEntityEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AnomalyModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"anomaly");
    public static final RegistryObject<EntityType<AnomalyBaseEntity>> ANOMALY_BASE = AnomalyModEntities.register("anomaly_base", EntityType.Builder.m_20704_(AnomalyBaseEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(60).setUpdateInterval(3).setCustomClientFactory(AnomalyBaseEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<AnomalyChaseEntity>> ANOMALY_CHASE = AnomalyModEntities.register("anomaly_chase", EntityType.Builder.m_20704_(AnomalyChaseEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AnomalyChaseEntity::new).m_20699_(0.8f, 1.8f));
    public static final RegistryObject<EntityType<AnomalyGhostEntity>> ANOMALY_GHOST = AnomalyModEntities.register("anomaly_ghost", EntityType.Builder.m_20704_(AnomalyGhostEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(AnomalyGhostEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<AnomalyDiamondEntity>> ANOMALY_DIAMOND = AnomalyModEntities.register("anomaly_diamond", EntityType.Builder.m_20704_(AnomalyDiamondEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(70).setUpdateInterval(3).setCustomClientFactory(AnomalyDiamondEntity::new).m_20699_(0.8f, 1.8f));
    public static final RegistryObject<EntityType<SoundEntityEntity>> SOUND_ENTITY = AnomalyModEntities.register("sound_entity", EntityType.Builder.m_20704_(SoundEntityEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(60).setUpdateInterval(3).setCustomClientFactory(SoundEntityEntity::new).m_20719_().m_20699_(0.1f, 0.1f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AnomalyBaseEntity.init();
            AnomalyChaseEntity.init();
            AnomalyGhostEntity.init();
            AnomalyDiamondEntity.init();
            SoundEntityEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ANOMALY_BASE.get(), AnomalyBaseEntity.createAttributes().m_22265_());
        event.put((EntityType)ANOMALY_CHASE.get(), AnomalyChaseEntity.createAttributes().m_22265_());
        event.put((EntityType)ANOMALY_GHOST.get(), AnomalyGhostEntity.createAttributes().m_22265_());
        event.put((EntityType)ANOMALY_DIAMOND.get(), AnomalyDiamondEntity.createAttributes().m_22265_());
        event.put((EntityType)SOUND_ENTITY.get(), SoundEntityEntity.createAttributes().m_22265_());
    }
}

